<?php
if (!defined('ABSPATH')) {
    exit;
}    // Exit if accessed directly

global $avia_config, $avia_pages, $avia_elements;

//	clear global values - avia_superobject::reset_options() includes this file a second time in avia_superobject::_create_option_arrays()
$avia_elements = array();

//	avia pages holds the data necessary for backend page creation
$avia_pages = array(
    array('slug' => 'avia', 'parent' => 'avia', 'icon' => "new/spanner-screwdriver-7@3x.png", 'title' => __('Theme Options', 'avia_framework')),
    array('slug' => 'layout', 'parent' => 'avia', 'icon' => "new/window-within-7@3x.png", 'title' => __('General Layout', 'avia_framework')),
    array('slug' => 'styling', 'parent' => 'avia', 'icon' => "new/color-palette-7@3x.png", 'title' => __('General Styling', 'avia_framework')),
    array('slug' => 'customizer', 'parent' => 'avia', 'icon' => "new/magic-wand-7@3x.png", 'title' => __('Advanced Styling', 'avia_framework')),
    array('slug' => 'menu', 'parent' => 'avia', 'icon' => "new/custom-menu@3x.png", 'title' => __('Main Menu', 'avia_framework')),
    array('slug' => 'header', 'parent' => 'avia', 'icon' => "new/layout-arrange-02-7@3x.png", 'title' => __('Header', 'avia_framework')),
    array('slug' => 'sidebars', 'parent' => 'avia', 'icon' => "new/layout-arrange-13-7@3x.png", 'title' => __('Sidebar Settings', 'avia_framework')),
    array('slug' => 'footer', 'parent' => 'avia', 'icon' => "new/layout-reverse@3x.png", 'title' => __('Footer', 'avia_framework')),
    array('slug' => 'builder', 'parent' => 'avia', 'icon' => "new/window-three-7@3x.png", 'title' => __('Layout Builder', 'avia_framework')),

    array('slug' => 'avia_element_templates',
        'parent' => 'avia',
        'icon' => 'new/window-plus-7@3x.png',
        'title' => __('Custom Elements', 'avia_framework')
    ),

    array('slug' => 'blog', 'parent' => 'avia', 'icon' => "new/note-write-7@3x.png", 'title' => __('Blog Layout', 'avia_framework')),
    array('slug' => 'social', 'parent' => 'avia', 'icon' => "new/circle-user-7@3x.png", 'title' => __('Social Profiles', 'avia_framework')),
    array('slug' => 'performance', 'parent' => 'avia', 'icon' => "new/performance-7@3x.png", 'title' => __('Performance', 'avia_framework')),
    array('slug' => 'cookie', 'parent' => 'avia', 'icon' => "new/cookie-7@3x.png", 'title' => __('Privacy and Cookies', 'avia_framework')),
    array('slug' => 'seo', 'parent' => 'avia', 'icon' => "new/seo-7@3x.png", 'title' => __('SEO Support', 'avia_framework')),
    array('slug' => 'newsletter', 'parent' => 'avia', 'icon' => "new/newspaper-7@3x.png", 'title' => __('Newsletter', 'avia_framework')),
    array('slug' => 'google', 'parent' => 'avia', 'icon' => "new/paper-map-7@3x.png", 'title' => __('Google Services', 'avia_framework')),
);

if (class_exists('woocommerce')) {
    $avia_pages[] = array('slug' => 'shop', 'parent' => 'avia', 'icon' => "new/shopping-cart-7@3x.png", 'title' => __('Shop Options', 'avia_framework'));
}


if (!current_theme_supports('avia_disable_import_export')) {
    $avia_pages[] = array('slug' => 'demo', 'parent' => 'avia', 'icon' => "new/window-up-7@3x.png", 'title' => __('Demo Import', 'avia_framework'));
    $avia_pages[] = array('slug' => 'upload', 'parent' => 'avia', 'icon' => "new/connect-arrow-up-down-7@3x.png", 'title' => __('Import/Export/...', 'avia_framework'));
}

//include( 'options_files/avia_ext_page.php' );
//include( 'options_files/avia_ext_tabs.php' );

include('options_files/avia_custom_elements.php');


//required for the general styling color schemes
include('register-backend-styles.php');

//required for the advanced styling wizard
include('register-backend-advanced-styles.php');

if (Enfold_Pagebuilder_API::is_activated() === true) {
    /**
     * Allow to include a user defined file to add or alter backend styles
     *
     * @return string        full path to the include file ( not a relative path !!! )
     * @since 4.5.5
     */
    $custom_path = apply_filters('avf_register_custom_backend_styles', '');
    if (!empty($custom_path) && file_exists($custom_path)) {
        include_once $custom_path;
    }

    /*	SEO - Search Engine Support		*/
    $avia_elements[] = array(
        'slug' => 'seo',
        'name' => __('Search Engine Optimization Support', 'avia_framework'),
        'desc' => __('The options here allow you to fine tune support of search engines or integration of search engine plugins.', 'avia_framework'),
        'id' => 'seo_header',
        'std' => '',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'seo',
        'type' => 'visual_group_start',
        'id' => 'avia_seo_index_start',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'seo',
        'name' => __('Meta tag &quot;robots&quot;', 'avia_framework'),
        'desc' => __('Select how Enfold will handle this header meta tag (index, follow). If you use a SEO plugin, you should leave this to plugin.', 'avia_framework'),
        'id' => 'seo_robots',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Use Enfold default settings', 'avia_framework') => '',
            __('Let SEO plugin set this tag', 'avia_framework') => 'plugin',
        )
    );

    $avia_elements[] = array(
        'slug' => 'seo',
        'name' => __('Automated Schema.org HTML Markup', 'avia_framework'),
        'desc' => __('The theme adds generic HTML schema markup to your template builder elements to provide additional context for search engines. If you want to add your own specific markup via plugins or custom HTML code, you can deactivate this setting', 'avia_framework'),
        'id' => 'markup',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Not activated', 'avia_framework') => 'inactive',
            __('Activated', 'avia_framework') => '',
        )
    );


    $avia_elements[] = array(
        'slug' => 'seo',
        'name' => __('Preprocessing Shortcodes In Header', 'avia_framework'),
        'desc' => __('Some SEO plugins need to process shortcodes when building the header. As this is time consuming it is disabled by default. Also if you experience problems you can leave it disabled until you find a solution to fix it.', 'avia_framework'),
        'id' => 'preprocess_shortcodes_in_header',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Do not allow to preprocess shortcodes', 'avia_framework') => '',
            __('allow to preprocess shortcodes', 'avia_framework') => 'preprocess_shortcodes_in_header'
        )
    );

    $avia_elements[] = array(
        'slug' => 'seo',
        'type' => 'visual_group_end',
        'id' => 'avia_seo_index_close',
        'nodescription' => true
    );


    /*Performance*/
    $avia_elements[] = array("name" => __("Website performance and optimization", 'avia_framework'),
        "desc" =>
            __("The options here allow you to fine-tune and speed up your theme depending on your needs.", 'avia_framework') . "<br>",

        "id" => "performance_header",
        "std" => "",
        "slug" => "performance",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_start", "id" => "avia_performance_compression_start", "nodescription" => true);


    $avia_elements[] = array("name" => __("File Compression", 'avia_framework'),
        "desc" =>
            __("In order to increase the speed of your website you can activate file merging and compression for your CSS and Javascript files. This will reduce and optimize the amount of code loaded.", 'avia_framework') . "<br><br>" . "<strong>" . __("Please note:", 'avia_framework') . " </strong>" .
            __("By default compression is enabled. It is recommended to only disable the feature when you encounter errors (some server environments might cause trouble with active compression) or while you are actively developing your website and are adding new CSS rules or Javascript functions.", 'avia_framework'),
        "id" => "performance_header",
        "std" => "",
        "slug" => "performance",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "slug" => "performance",
        "name" => __("CSS file merging and compression", 'avia_framework'),
        "desc" => __("Select which level of file merging and compression you want to apply to your CSS files", 'avia_framework'),
        "id" => "merge_css",
        "type" => "select",
        "std" => "avia",
        "no_first" => true,
        "subtype" => array(__('Disable - no CSS file merging and compression', 'avia_framework') => 'none',
            /*__('Compress advanced template builder CSS files (level 1)', 'avia_framework') =>'avia-module',*/
            __('Enable - merge and compress all theme CSS files', 'avia_framework') => 'avia',
            /*__('Compress all theme and plugin CSS files (level 3)', 'avia_framework') => "all",*/
        ));


    $avia_elements[] = array(
        "slug" => "performance",
        "name" => __("Javascript file merging and compression", 'avia_framework'),
        "desc" => __("Select which level of file merging and compression you want to apply to your Javascript files.", 'avia_framework'),
        "id" => "merge_js",
        "type" => "select",
        "std" => "avia",
        "no_first" => true,
        "subtype" => array(__('Disable - no Javascript file merging and compression', 'avia_framework') => 'none',
            /*__('Compress advanced template builder javascript files (level 1)', 'avia_framework') =>'avia-module',*/
            __('Enable - merge and compress all theme javascript files', 'avia_framework') => 'avia',
            /* __('Compress all theme and plugin files (level 3)', 'avia_framework') => "all", */
        ));

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Show advanced options', 'avia_framework'),
        'desc' => __('Contains options for special use cases when problems occur using compression', 'avia_framework'),
        'id' => 'merge_show_advanced',
        'type' => 'checkbox',
        'std' => false,
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Http security level for checking readability of merged files', 'avia_framework'),
        'desc' => __('Some server configuration make problems with ssl certificates (mostly self-signed certificates) when we check the readability of created merged files. In that case the files are not created. If you experience such problems try to disable the ssl verification during the creation process. This does not effect the protocol on frontend pageload.', 'avia_framework'),
        'id' => 'merge_disable_ssl',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'required' => array('merge_show_advanced', '{contains_array}merge_show_advanced'),
        'subtype' => array(
            __('Use ssl verification if needed for site (= default)', 'avia_framework') => '',
            __('Disable ssl verification when checking readability of merged files', 'avia_framework') => 'disable_ssl',
        )
    );

    $desc = __('As long as you do not change the theme version number all changes to content of js or css files will result in the same hash extension - this means browsers will not recognize these changes until the browser cache expires. To fix this Enfold adds an additional unique timestamp (since 4.7).', 'avia_framework') . '<br /><br />';
    $desc .= __('Some server configurations cache internal WP data and caused by a known but not yet fixed WP bug return wrong information about the existence of a compressed file - resulting in generating a new file again on every pageload and a rapidly growing folder ../wp-content/uploads/dynamic_avia.', 'avia_framework') . '<br /><br />';
    $desc .= __('To avoid this you can select here to fix this WP bug. You can also supress adding the timestamp - if you wish. Depending on your hoster it may still take some time till this setting will work correctly. Disable file merging, select &quot;Delete old CSS and JS files&quot; - wait for some time, clear server cache and then reactivate your settings.', 'avia_framework');

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Unique timestamp of merged files and WP object cache bug', 'avia_framework'),
        'desc' => $desc,
        'id' => 'merge_disable_unique_timestamp',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'required' => array('merge_show_advanced', '{contains_array}merge_show_advanced'),
        'subtype' => array(
            __('Add unique timestamps (= default)', 'avia_framework') => '',
            __('Disable adding unique timestamps only', 'avia_framework') => 'disable_unique_timestamp',
            __('Fix WP bug, add unique timestamps', 'avia_framework') => 'fix_wp_bug',
            __('Fix WP bug, disable unique timestamps', 'avia_framework') => 'disable_unique_timestamp fix_wp_bug'

        )
    );


    $desc = __('On some server configurations you might be receiving error messages like &quot;Remove query strings from static resources&quot;.', 'avia_framework') . ' ';
    $desc .= '<a href="https://kinsta.com/knowledgebase/remove-query-strings-static-resources/" target="_blank" rel="noopener noreferrer">' . __('Background information', 'avia_framework') . '</a>' . '<br /><br />';
    $desc .= __('Select here to remove the query string from static resources - but be aware the query strings allow browsers to detect changes to files and invalidate the browser cached files. Not doing this might break the layout or function of your site after an update until these files expire in browser cache.', 'avia_framework') . '<br /><br />';
    $desc .= __('THIS OPTION IS IGNORED WHEN WP_DEBUG = true.', 'avia_framework');

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Remove query string from static resources', 'avia_framework'),
        'desc' => $desc,
        'id' => 'remove_query_string_from_resources',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'required' => array('merge_show_advanced', '{contains_array}merge_show_advanced'),
        'subtype' => array(
            __('Leave query strings', 'avia_framework') => '',
            __('Remove query strings', 'avia_framework') => 'remove_query_string_from_resources',
        )
    );

    $desc = __('Select font display behaviour for your uploaded custom fonts and icon fonts. Please read carefully backend documentation before changing. You can also use filter avf_font_display.', 'avia_framework') . '<br />';
    $desc .= '<a href="https://developers.google.com/web/updates/2016/02/font-display" target="_blank" rel="noopener noreferrer">' . __('Controlling Font Performance with font-display', 'avia_framework') . '</a>' . '<br />';
    $desc .= '<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display" target="_blank" rel="noopener noreferrer">' . __('MDN font-display', 'avia_framework') . '</a>' . '<br />';

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Custom Font Display Behaviour', 'avia_framework'),
        'desc' => $desc,
        'id' => 'custom_font_display',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'required' => array('merge_show_advanced', '{contains_array}merge_show_advanced'),
        'subtype' => array(
            __('auto (= default)', 'avia_framework') => '',
            __('block', 'avia_framework') => 'block',
            __('swap', 'avia_framework') => 'swap',
            __('fallback', 'avia_framework') => 'fallback',
            __('optional', 'avia_framework') => 'optional'
        )
    );


    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_end", "id" => "avia_compression_close", "nodescription" => true);

    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_start", "id" => "avia_performance_compression_start4", "nodescription" => true);


    $avia_elements[] = array("name" => __("Disable Template Builder Elements", 'avia_framework'),
        "desc" =>
            __("The theme allows you to disable template builder elements that you do not need. This reduces the amount of Javascript and CSS loaded in your frontend", 'avia_framework') . "<br>",

        "id" => "performance_header_3",
        "std" => "",
        "slug" => "performance",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "slug" => "performance",
        "name" => __("Disabling of template builder elements", 'avia_framework'),
        "desc" => __("By default the theme will only load elements that are used on your posts and pages. You can disable the feature or manually manage loaded elements if you run into trouble", 'avia_framework'),
        "id" => "disable_alb_elements",
        "type" => "select",
        "std" => "auto",
        "no_first" => true,
        "subtype" => array(__('Always load all elements', 'avia_framework') => 'load_all',
            __('Load only used elements (recommended)', 'avia_framework') => 'auto',
            __('Manually manage loaded elements', 'avia_framework') => 'manually',
        ));


    $avia_elements[] = array(
        "id" => "alb_disabled",
        "type" => "template_builder_element_loader",
        "std" => "",
        "required" => array('disable_alb_elements', 'manually'),
        "nodescription" => true,
        "slug" => "performance");

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Scan Widgets for Theme Shortcodes', 'avia_framework'),
        'desc' => __('Enable scan only when you use Theme Shortcodes in widgets and do not use these in pages/posts. If you run into troubles please use one of the other options. Please reload the widget page when finished editing to force a scan of the widgets.', 'avia_framework'),
        'id' => 'scan_widgets_for_alb_elements',
        'required' => array('disable_alb_elements', 'auto'),
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Do not scan widgets', 'avia_framework') => '',
            __('Scan widgets', 'avia_framework') => 'scan_widgets'
        )
    );


    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_end", "id" => "avia_compression_close4", "nodescription" => true);

    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_start", "id" => "avia_performance_compression_start2", "nodescription" => true);


    $avia_elements[] = array("name" => __("Disable Features", 'avia_framework'),
        "desc" =>
            __("Here you can disable theme features that are not used by every website", 'avia_framework') . "<br>",

        "id" => "performance_header_2",
        "std" => "",
        "slug" => "performance",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Self hosted videos and audio features (WP-Mediaelement scripts)', 'avia_framework'),
        'desc' => __('By default the theme will load wp-mediaelement scripts only if needed on your posts and pages. You can disable the feature or force loading these elements if you run into troubles - some plugins require these elements and rely on the WP default behaviour loading these scripts.', 'avia_framework'),
        'id' => 'disable_mediaelement',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Default - only load when needed (recommended)', 'avia_framework') => '',
            __('Disable self hosted video and audio features', 'avia_framework') => 'disable_mediaelement',
            __('Always load media features (= WP default behaviour)', 'avia_framework') => 'force_mediaelement',
        )
    );

    $avia_elements[] = array(
        "name" => __("Disable external video features", 'avia_framework'),
        "desc" => __("Check if you do not use Youtube or Vimeo video features.", 'avia_framework'),
        "id" => "disable_video",
        "type" => "checkbox",
        "std" => "",
        "slug" => "performance");


    $avia_elements[] = array(
        "name" => __("Disable the blog", 'avia_framework'),
        "desc" => __("Check if you do not use the blog. This will disable the blog page as well as the blog template builder element, the comments template builder element and category pages that are based on the default categories (if any plugin post types use these overview styles please keep this feature enabled)", 'avia_framework'),
        "id" => "disable_blog",
        "type" => "checkbox",
        "std" => "",
        "slug" => "performance");


    $avia_elements[] = array("slug" => "performance", "type" => "visual_group_end", "id" => "avia_compression_close2", "nodescription" => true);


    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_start',
        'id' => 'avia_performance_compression_start3',
        'nodescription' => true
    );


    $avia_elements[] = array("name" => __("Change WordPress defaults", 'avia_framework'),
        "desc" =>
            __("Here you can disable WordPress default scripts and styles that are not necessary for most websites", 'avia_framework') . "<br>",

        "id" => "performance_header_2",
        "std" => "",
        "slug" => "performance",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "name" => __("Disable Emoji/Smiley Support", 'avia_framework'),
        "desc" => __("Check to disable Emoji/Smiley Support. (Emojis are used by WordPress by default but most websites do not use them)", 'avia_framework'),
        "id" => "disable_emoji",
        "type" => "checkbox",
        "std" => "",
        "slug" => "performance");

    if (avia_count_active_plugins() > 0) {

        $avia_elements[] = array(
            "name" => __("Disable jQuery Migrate", 'avia_framework'),
            "desc" => __("Check to disable 'jQuery Migrate'. It is an old backward compatibility library for jQuery that is required by some plugins. Make sure that none of your active plugins require it before disabling it!", 'avia_framework'),
            "id" => "disable_jq_migrate",
            "type" => "checkbox",
            "std" => "",
            "slug" => "performance");

        $avia_elements[] = array(
            "name" => __("Load jQuery in your footer", 'avia_framework'),
            "desc" => __("Loading jQuery in your footer will speed up site rendering but may cause problems with plugins. Only use if you know what you are doing ;-)", 'avia_framework'),
            "id" => "jquery_in_footer",
            "type" => "checkbox",
            "std" => "",
            "slug" => "performance");
    }


    $avia_elements[] = array(
        "name" => __("Load Google fonts in footer", 'avia_framework'),
        "desc" => __("Loading the fonts in your footer will speed up the site rendering, but also cause a small flicker of text on page load", 'avia_framework'),
        "id" => "gfonts_in_footer",
        "type" => "checkbox",
        "std" => "",
        "slug" => "performance");


    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_end',
        'id' => 'avia_compression_close3',
        'nodescription' => true
    );


    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_start',
        'id' => 'avia_performance_compression_start4',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Responsive Images And Lazy Loading', 'avia_framework'),
//					'desc'			=> __( 'Responsive images are supported using the logic provided by WP.', 'avia_framework') . '<br />',
        'id' => 'performance_header_4',
        'type' => 'heading',
        'nodescription' => true
    );

    $desc = __('Select to enable lazy loading using native HTML. Currently WP only supports images, but this might be extended for iframes in future. Please keep in mind that lazy loading might break animations when scrolling to images.', 'avia_framework') . ' ';
    $desc .= __('If you disable lazy loading here this will override any specific element settings of ALB elements. It might not work for 3rd party plugins not using the WP API correctly.', 'avia_framework');

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Lazy Loading', 'avia_framework'),
        'desc' => $desc,
        'id' => 'lazy_loading',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Enable lazy loading', 'avia_framework') => '',
            __('Disable lazy loading', 'avia_framework') => 'no_lazy_loading_all',
        )
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Responsive Images', 'avia_framework'),
        'desc' => __('Check to enable theme support for responsive images using the standard WP implementation for this feature.', 'avia_framework'),
        'id' => 'responsive_images',
        'type' => 'checkbox',
        'std' => 'responsive_images'
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_start',
        'id' => 'avia_performance_responsive_images_start',
        'class' => 'visual-set-no-top-border',
        'nodescription' => true,
        'required' => array('responsive_images', '{contains_array}responsive_images')
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Image Thumbnails Info', 'avia_framework'),
        'desc' => __('Select to show a grouped overview of available image thumbnails.', 'avia_framework'),
        'id' => 'responsive_images_thumbs',
        'type' => 'checkbox',
        'std' => false
    );

    $desc = __('In case you need additional image sizes you can use a plugin like', 'avia_framework') . ' ';
    $desc .= '<a href="https://wordpress.org/plugins/simple-image-sizes/" target="_blank" rel="noopener noreferrer">Simple Image Sizes</a>. ';
    $desc .= __('For advanced users:', 'avia_framework') . ' ';
    $desc .= '<a href="https://github.com/KriesiMedia/enfold-library/blob/master/actions%20and%20filters/Layout/avf_modify_thumb_size.php" target="_blank" rel="noopener noreferrer">Enfold Code Snippets Library</a>.';

    $avia_elements[] = array(
        'slug' => 'performance',
        'name' => __('Responsive Images Thumbnails Overview:', 'avia_framework'),
        'desc' => $desc,
        'type' => 'heading',
        'id' => 'performance_header_responsive_img',
        'nodescription' => true,
        'required' => array('responsive_images_thumbs', '{contains_array}responsive_images_thumbs')
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'responsive_images_overview',
        'id' => 'responsive_images_overview',
        'nodescription' => true,
        'required' => array('responsive_images_thumbs', '{contains_array}responsive_images_thumbs')
    );

    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_end',
        'id' => 'avia_performance_responsive_images_end',
        'nodescription' => true
    );


    $avia_elements[] = array(
        'slug' => 'performance',
        'type' => 'visual_group_end',
        'id' => 'avia_compression_close4',
        'nodescription' => true
    );


    $avia_elements[] = array(
        "name" => __("Image Optimization", 'avia_framework'),
        "desc" => __("Enfold checks if it can detect an image optimization plugin and if it can't find a familiar one recommends a few that are known to work great with the theme", 'avia_framework') . "<br>" .
            __("(If you are running an image optimization plugin that is not detected just ignore this message)", 'avia_framework'),
        "id" => "image_optimisation_check",
        "type" => "plugin_check",
        "slug" => "performance",
        "nodescription" => true,
        "no_found" => __("We were not able to detect an active image optimization plugin. It is recommended to use one to speed up your site. Here are a few suggestions:", 'avia_framework'),
        "found" => __("We were able to detect an image optimization plugin. Great! Nothing left to do here ;)", 'avia_framework'),
        "too_many" => __("We were able to detect multiple active image optimization plugins. It is recommended to use only one!", 'avia_framework'),

        "plugins" => array(
            'Optimus - WordPress Image Optimizer' => array(
                'download' => 'optimus',
                'file' => 'optimus/optimus.php',
                'desc' =>
                    "<ul>
            	<li>Simple to use with only a few options</li>
            	<li>Good size reduction while keeping images pretty</li>
            	<li>Very good google pagespeed scores</li>
            	<li>Free version works already good, premium version is even better and also rather cheap</li>
            </ul>"
            ),


            'ShortPixel Image Optimizer' => array('download' => 'shortpixel-image-optimiser', 'file' => 'shortpixel-image-optimiser/wp-shortpixel.php', 'desc' =>
                "<ul>
            	<li>Fine tuning possible due to more options</li>
            	<li>Allows you to heavily reduce file size if image quality is not a concern</li>
            	<li>Good google pagespeed scores</li>
            	<li>Free version will be sufficient for most smaller sites.</li>
            </ul>"
            ),

            'WP Smush - Image Optimization' => array('download' => 'resmushit-image-optimizer', 'file' => 'wp-smushit/wp-smush.php'),
            'Imagify Image Optimizer' => array('download' => 'imagify', 'file' => 'imagify/imagify.php'),
            'Compress JPEG & PNG images (TinyPNG)' => array('download' => 'tiny-compress-images', 'file' => 'tiny-compress-images/tiny-compress-images.php'),
            'Kraken.io Image Optimizer' => array('download' => 'kraken-image-optimizer', 'file' => 'kraken-image-optimizer/kraken.php'),
            'EWWW Image Optimizer' => array('download' => 'ewww-image-optimizer', 'file' => 'ewww-image-optimizer/ewww-image-optimizer.php'),
            'EWWW Image Optimizer Cloud' => array('download' => 'ewww-image-optimizer-cloud', 'file' => 'ewww-image-optimizer-cloud/ewww-image-optimizer-cloud.php'),
            'CheetahO Image Optimizer' => array('download' => 'cheetaho-image-optimizer', 'file' => 'cheetaho-image-optimizer/cheetaho.php'),
            'Zara 4 Image Compression' => array('download' => 'zara-4', 'file' => 'zara-4/zara-4.php'),
            'ImageRecycle pdf & image compression' => array('download' => 'imagerecycle-pdf-image-compression', 'file' => 'imagerecycle-pdf-image-compression/wp-image-recycle.php'),
            'Prizm Image' => array('download' => false, 'file' => 'prizm-image/wp-prizmimage.php'),
            'CW Image Optimizer' => array('download' => false, 'file' => 'cw-image-optimizer/cw-image-optimizer.php'),
            'Imsanity' => array('download' => 'imsanity', 'file' => 'imsanity/imsanity.php'),
            'Way2enjoy Image Optimizer and Resize Image – WordPress Image Compression' =>
                array('download' => 'way2enjoy-compress-images', 'file' => 'way2enjoy-compress-images/way2enjoy.php'),
            'JPG, PNG Compression and Optimization' => array('download' => 'wp-image-compression', 'file' => 'wp-image-compression/wp-image-compression.php'),
            'Highcompress Image Compressor' => array('download' => 'high-compress', 'file' => 'high-compress/highcompress.php'),
            'Image Optimizer by 10web – Image Optimizer and Compression plugin'
            => array('download' => 'image-optimizer-wd', 'file' => 'image-optimizer-wd/io-wd.php'),
            'Ultimate Image Optimization Helpers' => array('download' => 'ultimate-image-optimization-helpers', 'file' => 'ultimate-image-optimization-helpers/ultimate-image-optimization-helpers.php'),
            'Pixpie – Intelligent Image Compression' => array('download' => 'wp-pixpie', 'file' => 'wp-pixpie/wp-pixpie-plugin.php'),
            'Resize Image After Upload' => array('download' => 'resize-image-after-upload', 'file' => 'resize-image-after-upload/resize-image-after-upload.php'),
            'TP Image Optimizer' => array('download' => 'tp-image-optimizer', 'file' => 'tp-image-optimizer/tp-image-optimizer.php'),
        )

    );


    $avia_elements[] = array(
        "name" => __("Caching Plugins", 'avia_framework'),
        "desc" => __("Enfold checks if it can detect a website caching plugin and if it can't find a familiar one recommends a few that are known to work great with the theme", 'avia_framework') . "<br>"
            . __("(If you are running a caching plugin that is not detected or your webhost has built in caching ignore this message)", 'avia_framework'),
        "id" => "image_optimisation_check",
        "type" => "plugin_check",
        "slug" => "performance",
        "nodescription" => true,
        "no_found" => __("We were not able to detect an active caching plugin. It is recommended to use one to speed up your site. Here are a few suggestions:", 'avia_framework'),
        "found" => __("We were able to detect a caching plugin. Great! Nothing left to do here ;)", 'avia_framework'),
        "too_many" => __("We were able to detect multiple active caching plugins. It is recommended to use only one!", 'avia_framework'),


        "plugins" => array(

            'WP Super Cache' => array('download' => 'wp-super-cache', 'file' => 'wp-super-cache/wp-cache.php', 'desc' =>
                "<ul>
            	<li>Great all around caching plugin</li>
            	<li>Easy setup (usually no need to change the default settings)</li>
            </ul>"
            ),


            'Comet Cache' => array('download' => 'comet-cache', 'file' => 'comet-cache/comet-cache.php', 'desc' =>
                "<ul>
            	<li>Plug and Play, no setup necessary</li>
            	<li>Premium version available</li>
            </ul>"
            ),

            'W3 Total Cache' => array('download' => 'w3-total-cache', 'file' => 'w3-total-cache/w3-total-cache.php', 'desc' =>
                "<ul>
            	<li>Fast</li>
            	<li>Easy to use</li>
            </ul>"
            ),


            'Comet Cache Pro' => array('download' => 'comet-cache', 'file' => 'comet-cache-pro/comet-cache-pro.php'),
            'Wot Cache' => array('download' => false, 'file' => 'wot-cache/wot-cache.php'),
            'WP Rocket' => array('download' => false, 'file' => 'wp-rocket/wp-rocket.php'),
            'WP Fastest Cache' => array('download' => 'wp-fastest-cache', 'file' => 'wp-fastest-cache/wpFastestCache.php'),
            'Simple Cache' => array('download' => 'simple-cache', 'file' => 'simple-cache/simple-cache.php'),
            'Cachify' => array('download' => 'cachify', 'file' => 'cachify/cachify.php'),
            'Hyper Cache' => array('download' => 'hyper-cache', 'file' => 'hyper-cache/plugin.php'),
            'Cache Enabler' => array('download' => 'cache-enabler', 'file' => 'cache-enabler/cache-enabler.php'),
            'Autoptimize' => array('download' => 'autoptimize', 'file' => 'autoptimize/autoptimize.php'),
            'Cache Control' => array('download' => 'cache-control', 'file' => 'cache-control/cache-control.php'),
            'Fast Velocity Minify' => array('download' => 'fast-velocity-minify', 'file' => 'fast-velocity-minify/fvm.php'),
            'Gator Cache' => array('download' => 'gator-cache', 'file' => 'gator-cache/gator-cache.php'),
            'Breeze' => array('download' => 'breeze', 'file' => 'breeze/breeze.php'),
            'Super Static Cache' => array('download' => 'super-static-cache', 'file' => 'super-static-cache/super-static-cache.php'),
            'YASAKANI Cache' => array('download' => 'yasakani-cache', 'file' => 'yasakani-cache/yasakani-cache.php.php'),
            'Lite Speed Cache' => array('download' => 'litespeed-cache', 'file' => 'litespeed-cache/litespeed-cache.php'),
            'Hummingbird Page Speed Optimization' => array('download' => 'hummingbird-performance', 'file' => 'hummingbird-performance/wp-hummingbird.php'),
            'Powered Cache' => array('download' => 'powered-cache', 'file' => 'powered-cache/powered-cache.php'),
            'Page Speed Optimization' => array('download' => 'above-the-fold-optimization', 'file' => 'above-the-fold-optimization/abovethefold.php'),
            'Varnish Caching' => array('download' => 'vcaching', 'file' => 'vcaching/vcaching.php'),
            'Borlabs Cache' => array('download' => false, 'file' => 'borlabs-cache/borlabs-cache.php'),
        )

    );
    $avia_elements[] = array(
        "name" => __("Delete old CSS and JS files?", 'avia_framework'),
        "desc" => __("Check if you want to delete expired CSS and JS files generated by the theme. Only recommended if you are NOT using a caching plugin (since a cached page might still use those files)", 'avia_framework'),
        "id" => "delete_assets_after_save",
        "type" => "checkbox",
        "std" => "",
        "slug" => "performance");


    /*builder*/
    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_start',
        'id' => 'avia_alb_general',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'name' => __('General Builder Options', 'avia_framework'),
        'desc' => '',
        'id' => 'avia_builder_general',
        'std' => '',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'name' => __('Disable Advanced Layout Builder preview in backend', 'avia_framework'),
        'desc' => __('Check to disable the live preview of your advanced layout builder elements', 'avia_framework'),
        'id' => 'preview_disable',
        'type' => 'checkbox',
        'std' => ''
    );


    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_end',
        'id' => 'avia_alb_general_close',
        'nodescription' => true
    );


    $loack_alb = 'checkbox';

    if (!current_user_can('switch_themes')) {
        $loack_alb = 'hidden';
    }

    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_start',
        'id' => 'avia_lock_alb',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'name' => __('Lock advanced layout builder', 'avia_framework'),
        'desc' => __('This removes the ability to move or delete existing template builder elements, or add new ones, for everyone who is not an administrator. The content of an existing element can still be changed by everyone who can edit that entry.', 'avia_framework'),
        'id' => 'lock_alb',
        'type' => $loack_alb,
        'std' => '',
        'slug' => 'builder'
    );


    $avia_elements[] = array(
        'name' => __('Lock advanced layout builder for admins as well?', 'avia_framework'),
        'desc' => __('This will lock the elements for all administrators including you, to prevent accidental changing of a page layout. In order to change a page layout later, you will need to uncheck this option first', 'avia_framework'),
        'id' => 'lock_alb_for_admins',
        'type' => $loack_alb,
        'std' => '',
        'required' => array('lock_alb', 'lock_alb'),
        'slug' => 'builder'
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_end',
        'id' => 'avia_lock_alb_close',
        'nodescription' => true
    );


    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_start',
        'id' => 'avia_alb_developers',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'name' => __('Hide template builder developer options', 'avia_framework'),
        'desc' => __('Activate to hide the developer options for template builder elements. (Usually located in the "advanced" tab of the element and containing options like custom IDs and CSS classes). More details can be found in our documentation: ', 'avia_framework') . '<a href="https://kriesi.at/documentation/enfold/intro-to-layout-builder/#developer-options" target="_blank" rel="noopener noreferrer">' . __('Intro to Layout Builder', 'avia_framework') . '</a>.',
        'id' => 'alb_developer_options',
        'type' => 'checkbox',
        'std' => ''
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_end',
        'id' => 'avia_alb_developers_close',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_start',
        'id' => 'avia_alb_options_toggles',
        'nodescription' => true
    );


    $subtype = array(
        __('Use Toggle Feature', 'avia_framework') => '',
        __('Disable Toggles and display all options', 'avia_framework') => 'section_headers',
    );

    /**
     * @param boolean
     * @return boolean
     * @since 4.7.3.1
     */
    if (false !== apply_filters('avf_show_option_toggles_advanced', false)) {
        $subtype[__('Show all options without section headers', 'avia_framework')] = 'no_section_headers';
    }

    $avia_elements[] = array(
        'slug' => 'builder',
        'name' => __('Options Toggles In Modal Popup', 'avia_framework'),
        'desc' => __('Select if you want to display toggles in modal windows for advanced layout builder elements or you prefer to see all options at once (old style)', 'avia_framework'),
        'id' => 'alb_options_toggles',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => $subtype
    );

    $avia_elements[] = array(
        'slug' => 'builder',
        'type' => 'visual_group_end',
        'id' => 'avia_alb_options_toggles_close',
        'nodescription' => true
    );

    /*menu*/
    $iconSpan = "<span class='pr-icons'>
				<img src='" . AVIA_IMG_URL . "icons/social_facebook.png' alt='' />
				<img src='" . AVIA_IMG_URL . "icons/social_twitter.png' alt='' />
				<img src='" . AVIA_IMG_URL . "icons/social_flickr.png' alt='' />
			</span>";

    $frontendheader_label = __("A rough layout preview of the main menu", 'avia_framework');

    $avia_elements[] = array(
        "slug" => "menu",
        "id" => "main_menu_preview",
        "type" => "target",
        "std" => "
					<style type='text/css'>
					
					#avia_options_page #avia_main_menu_preview{background: #f8f8f8; padding: 30px;border-bottom: 1px solid #e5e5e5; margin-bottom: 25px;}
					#av-main-menu-preview-container{color:#999; border:1px solid #e1e1e1; padding:0px 45px; overflow:hidden; background-color:#fff; position: relative;}
					
					#avia_options_page #pr-main-area{line-height:69px; overflow:hidden;}
					
					.main-menu-wrap{float:left; height:70px; line-height:70px;}
					
					
					[data-av_set_global_tab_active='av_display_burger'] .av-header-area-preview-menu-only #av-menu-overlay{display:block;}
					[data-av_set_global_tab_active='av_display_burger'] .av-header-area-preview-menu-only #pr-burger-menu{display:block;}
					[data-av_set_global_tab_active='av_display_burger'] #pr-menu #pr-menu-inner{display:none;}
					
					
					#av-menu-overlay{position: absolute; right:31px; display:none; bottom: 31px; top: 54px; left: 31px; background: rgba(0,0,0,0.2); z-index: 1;}
					#av-menu-overlay .av-overlay-menu-item{display:block; padding:8px 20px; border-bottom: 1px solid #e1e1e1;}
					#av-menu-overlay .av-overlay-menu-item-sub{display:block; color:#999;}
					#av-menu-overlay-scroll{position:absolute; top:0; left:0; bottom:0; width:280px; background:#fff; padding-top:70px; color:#666;}
					[data-submenu_visibility*='av-submenu-hidden'] #av-menu-overlay .av-overlay-menu-item-sub{display:none;}
					[data-burger_size*='av-small-burger-icon'] #pr-burger-menu{    -ms-transform: scale(0.6); transform: scale(0.6);}
					
					
					[data-overlay_style='av-overlay-full'] #av-menu-overlay-scroll{background:transparent; color:#fff; width:100%; text-align: center;}
					[data-overlay_style='av-overlay-full'] #av-menu-overlay .av-overlay-menu-item{border:none; font-size:16px;}
					[data-overlay_style='av-overlay-full'] #av-menu-overlay{ background: rgba(0,0,0,0.8);}
					[data-av_set_global_tab_active='av_display_burger'] [data-overlay_style='av-overlay-full'] #pr-burger-menu span{border-color:#fff;}
					
					
					[data-overlay_style*='av-overlay-side-minimal'] #av-menu-overlay-scroll{display:table; height:100%;padding:0;}
					[data-overlay_style*='av-overlay-side-minimal'] #av-menu-overlay-scroll > *{display:table-cell; height:100%; vertical-align:middle;}
					[data-overlay_style*='av-overlay-side-minimal'] #av-menu-overlay .av-overlay-menu-item{border:none;}
					
					</style>
					<div class='av-header-area-preview av-header-area-preview-menu-only' >
					
						<div id='av-menu-overlay'>					
							<div id='av-menu-overlay-scroll'>
									<div id='av-menu-overlay-scroll-inner'>
									<span class='av-overlay-menu-item'>خانه</span>
									<span class='av-overlay-menu-item'>درباره</span>
									<span class='av-overlay-menu-item av-overlay-menu-item-sub'>- تیم</span>
									<span class='av-overlay-menu-item av-overlay-menu-item-sub'>- تاریخچه</span>
									<span class='av-overlay-menu-item'>تماس</span>
								</div>
							</div>
						</div>
						
						<div id='pr-stretch-wrap' >
							<small class='live_bg_small'>{$frontendheader_label}</small>
							<div id='pr-header-style-wrap' >
								<div id='pr-phone-wrap' >
									<div id='pr-social-wrap' >
										<div id='pr-seconary-menu-wrap' >
											<div id='pr-menu-2nd'>{$iconSpan}<span class='pr-secondary-items'>ورود / ثبت نام / ...</span><span class='pr-phone-items'>تلفن: 0210000</span></div>
											<div id='avia_header_preview' >
												<div id='pr-main-area' >
													<img id='pr-logo' src='" . AVIA_BASE_URL . "images/layout/logo_modern.png' alt=''/>
													<div id='pr-main-icon'>{$iconSpan}</div>
													<div id='pr-menu'>
													
													
													<span id='pr-menu-inner'><span class='pr-menu-single pr-menu-single-first'>خانه</span><span class='pr-menu-single'>درباره</span><span class='pr-menu-single'>تماس</span></span> <img id='search_icon' src='" . AVIA_BASE_URL . "images/layout/search.png'  alt='' />
													<div id='pr-burger-menu'>
														<span class='burger-top'></span>
														<span class='burger-mid'></span>
														<span class='burger-low'></span>
													</div>

													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div id='pr-content-area'> محتوا / اسلایدشوها / ... 
							<div class='inner-content'><p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد. </p>
							
							<p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.</p>
							
							<p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.</p>
							
							</div>
							</div>
						</div>
					</div>
					",
        "nodescription" => true
    );

//START TAB CONTAINER
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_start", "id" => "avia_tab1", "nodescription" => true, 'class' => 'avia_tab_container avia_set');

// Start TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('General', 'avia_framework'));


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Items for Desktop", 'avia_framework'),
        "desc" => __("Choose how you want to display the menu items on desktop computers. If you choose to display the 'burger' icon on desktop computers it will also be used on tablets and mobile devices ", 'avia_framework'),
        "id" => "menu_display",
        "type" => "select",
        "std" => "",
        //"required" => array('header_layout','{contains}main_nav_header'),
        "target" => array(".av-header-area-preview::#pr-menu::set_class"),
        "no_first" => true,
        "subtype" => array(__('Display as text', 'avia_framework') => '',
            __('Display as icon', 'avia_framework') => 'burger_menu',
        ));

    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Alternate Menu for Mobile", 'avia_framework'),
        "desc" => __("Choose if you want to display the alternate menu on mobile devices.", 'avia_framework'),
        "id" => "alternate_menu",
        "type" => "select_menu",
        "std" => "",
        "required" => array('menu_display', ''),
        "no_first" => true,
        "subtype" => array(
            __('Do not use an alternate menu for mobile', 'avia_framework') => ''
        )
    );

    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Items for mobile", 'avia_framework'),
        "desc" => __("The mobile menu is usually displayed on Smartphone screensize only. If you have a lot of main menu items you might want to activate it for tablet screen size as well so it doesn't overlap the logo on tablets or small screens", 'avia_framework'),
        "id" => "header_mobile_activation",
        "type" => "select",
        "std" => "mobile_menu_phone",
        "required" => array('menu_display', ''),
        "no_first" => true,
        "subtype" => array(__('Activate only for Smartphones (browser width below 768px)', 'avia_framework') => 'mobile_menu_phone',
            __('Activate for Smartphones and Tablets (browser width below 990px)', 'avia_framework') => 'mobile_menu_tablet',
        ));

    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Separator between menu items", 'avia_framework'),
        "desc" => __("Choose if you want to display a border between menu items", 'avia_framework'),
        "id" => "header_menu_border",
        "type" => "select",
        "std" => "",
        "target" => array(".av-header-area-preview::#pr-menu-inner::set_class"),
        "no_first" => true,
        "required" => array('menu_display', ''),
        "subtype" => array(__('No separator', 'avia_framework') => '',
            __('Small separator', 'avia_framework') => 'seperator_small_border',
            __('Large separator', 'avia_framework') => 'seperator_big_border',
        ));

    $avia_elements[] = array(
        "name" => __("Append search icon to main menu", 'avia_framework'),
        "desc" => __("If enabled a search Icon will be appended to the main menu that allows the users to perform an 'AJAX' Search", 'avia_framework'),
        "id" => "header_searchicon",
        "type" => "checkbox",
        "std" => "true",
        "target" => array(".av-header-area-preview::#search_icon::set_class"),
        "slug" => "menu");

// END TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


// Start TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Burger/Mobile Menu', 'avia_framework'), "global_class" => 'av_display_burger');


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Icon Submenu items", 'avia_framework'),
        "desc" => __("Choose how to display the submenu items of the icon menu", 'avia_framework'),
        "id" => "submenu_visibility",
        "type" => "select",
        "std" => "",
        "target" => array("#avia_main_menu_preview::.avia_control_container::set_data"),
        "no_first" => true,
        "subtype" => array(__('Always display submenu items', 'avia_framework') => '',
            __('Display submenu items on click', 'avia_framework') => 'av-submenu-hidden av-submenu-display-click',
            __('Display submenu items on hover', 'avia_framework') => 'av-submenu-hidden av-submenu-display-hover',
        ));


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Clone title menu items to submenu", 'avia_framework'),
        "desc" => __("Since you selected to display submenu items on click or on hover, the parent menu item does no longer navigate to the URL it contains, but toggles the visibility of its submenu items. If you want users to be able to open the parent menu URL the theme can create a clone of that item in the submenu", 'avia_framework'),
        "id" => "submenu_clone",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "required" => array('submenu_visibility', '{contains_array}av-submenu-display-click;av-submenu-display-hover'),
        "subtype" => array(__('Do not create a clone', 'avia_framework') => 'av-submenu-noclone',
            __('Create a clone for the title menu item', 'avia_framework') => 'av-submenu-clone',
        ));


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Icon Style", 'avia_framework'),
        "desc" => __("Set the style of the 'Burger' Icon", 'avia_framework'),
        "id" => "burger_size",
        "type" => "select",
        "std" => "",
        "target" => array(".av-header-area-preview::#pr-stretch-wrap::set_data"),
        "no_first" => true,
        "subtype" => array(__('Default', 'avia_framework') => '',
            __('Small', 'avia_framework') => 'av-small-burger-icon',
        ));


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Overlay Style", 'avia_framework'),
        "desc" => __("Set the style of the page overlay that appears when the burger menu is clicked", 'avia_framework'),
        "id" => "overlay_style",
        "type" => "select",
        "std" => "av-overlay-side av-overlay-side-classic",
        "target" => array("#avia_main_menu_preview::.avia_control_container::set_data"),
        "no_first" => true,
        "subtype" => array(__('Full Page Overlay Menu', 'avia_framework') => 'av-overlay-full',
            __('Sidebar Flyout Menu (Classic)', 'avia_framework') => 'av-overlay-side av-overlay-side-classic',
            __('Sidebar Flyout Menu (Minimal)', 'avia_framework') => 'av-overlay-side av-overlay-side-minimal',
        ));


// END TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


// Start TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Burger/Mobile Menu styling', 'avia_framework'), "global_class" => 'av_display_burger');


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Menu Icon Color", 'avia_framework'),
        "desc" => __("Set a custom color of the 'Burger' Icon. Leave empty to use the default menu color", 'avia_framework'),
        "id" => "burger_color",
        "type" => "colorpicker",
        "class" => "",
        "std" => ""
    );


    $avia_elements[] = array(
        "slug" => "menu",
        "name" => __("Flyout width", 'avia_framework'),
        "desc" => __("Set a custom width for the Flyout. Pixel and % values are allowed. Eg: 350px or 70%", 'avia_framework'),
        "id" => "burger_flyout_width",
        "type" => "text",
        "class" => "",
        "std" => "350px"
    );


    $avia_elements[] = array("name" => __("Advanced color and styling options", 'avia_framework'),
        "desc" => __("You can edit more and advanced color and styling options for the overlay/slideout menu items in") .
            " <a href='#goto_customizer'>" .
            __("Advanced Styling", 'avia_framework') .
            "</a>",
        "id" => "overlay_description",
        "std" => "",
        "slug" => "menu",
        "type" => "heading",
        "nodescription" => true);


// END TAB
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


//END TAB CONTAINER
    $avia_elements[] = array("slug" => "menu", "type" => "visual_group_end", "id" => "avia_tab_container_end", "nodescription" => true);


    /*google*/

    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_start',
        'id' => 'avia_google_analytics_group',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Google Analytics', 'avia_framework'),
        'desc' => '',
        'id' => 'avia_google_analytics_heading',
        'std' => '',
        'type' => 'heading',
        'nodescription' => true
    );

    $desc = __('Either enter your Google tracking id (UA-XXXXX-X), (G-XXXXX) or your full Google Analytics tracking Code here.', 'avia_framework');
    $desc .= '<br><br>';
    $desc .= __('If you want to offer your visitors the option to stop being tracked you can place the shortcode [av_privacy_google_tracking] somewhere on your site.', 'avia_framework') . ' ';
    $desc .= __('More information and more privacy settings you find here:', 'avia_framework') . ' ';
    $desc .= '<a href="' . admin_url('admin.php?page=avia#goto_cookie') . '">' . __('Privacy and Cookies', 'avia_framework') . '</a>';

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Google Analytics Tracking Code', 'avia_framework'),
        'desc' => $desc,
        'id' => 'analytics',
        'type' => 'textarea',
        'std' => '',
        'class' => 'av_small_textarea',
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_end',
        'id' => 'avia_google_analytics_group_end',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_start',
        'id' => 'avia_google_maps_group',
        'nodescription' => true
    );


    $google_link = 'https://console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend,places_backend&keyType=CLIENT_SIDE&reusekey=true';
    $tutorial_link = 'https://kriesi.at/documentation/enfold/how-to-register-a-google-maps-api-key/';


    $avia_elements[] = array(
        'name' => __('Google Maps', 'avia_framework'),
        'desc' => __('Google recently changed the way their map service works. New pages which want to use Google Maps need to register an API key for their website. Older pages should work fine without this API key. If the google map elements of this theme do not work properly you need to register a new API key.', 'avia_framework') . "<br><a href='{$google_link}' target='_blank' rel='noopener noreferrer'>" . __('Register an API Key', 'avia_framework') . "</a> | <a target='_blank' href='{$tutorial_link}' rel='noopener noreferrer'>" . __('Tutorial: How to create an API key', 'avia_framework') . '</a>',
        'id' => 'avia_gmaps_heading',
        'std' => '',
        'slug' => 'google',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Enable Google Maps on your site', 'avia_framework'),
        'desc' => __('Select if you want to use Google Maps on your site. If it is disabled no Javascript to connect to Google Maps will be loaded in frontend.', 'avia_framework'),
        'id' => 'gmap_enabled',
        'type' => 'select',
        'std' => 'disable_gmap',
        'no_first' => true,
        'subtype' => array(
            __('Disable Google Maps', 'avia_framework') => 'disable_gmap',
            __('Use Google Maps', 'avia_framework') => ''
        )
    );


    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Enter a valid Google Maps API Key to use all map related theme functions', 'avia_framework'),
        'desc' => '',
        'id' => 'gmap_api',
        'required' => array('gmap_enabled', ''),
        'type' => 'verification_field',
        'ajax' => 'av_maps_api_check',
        'js_callback' => 'av_maps_js_api_check',
        'class' => 'av_full_description',
        'button-label' => __('Check API Key', 'avia_framework'),
        'button-relabel' => __(' Check API Key', 'avia_framework'),
        'std' => ''
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'std' => '',
        'name' => __('Last verify state - hidden - used for internal use only', 'avia_framework'),
        'desc' => '',
        'id' => 'gmap_verify_state',
        'type' => 'hidden',
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'std' => '',
        'name' => __('Last verified keys - hidden - used for internal use only', 'avia_framework'),
        'desc' => '',
        'id' => 'gmap_verified_key',
        'type' => 'hidden',
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_end',
        'id' => 'avia_google_maps_group_end',
        'nodescription' => true
    );


    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_start',
        'id' => 'avia_google_recaptcha_group',
        'class' => 'av-verify-button-container',
        'nodescription' => true
    );

    $recaptcha = 'https://developers.google.com/recaptcha/intro';
    $recaptcha_v3 = 'https://developers.google.com/recaptcha/docs/v3';
    $recaptcha_admin = 'https://www.google.com/recaptcha/admin';
    $recaptcha_doc = 'https://kriesi.at/documentation/enfold/contact-form/#captcha';

    $recaptcha_desc = __('Add Google reCAPTCHA widget functionality to the theme to verify if user is a human. Currently only enfold contact forms are supported and you can choose for each form individually if you want to use a reCAPTCHA.', 'avia_framework') . '<br />';
    $recaptcha_desc .= sprintf(__('Info about <a href="%1$s" target="_blank" rel="noopener noreferrer">Google reCAPTCHA</a>. You need to create <a href="%2$s" target="_blank" rel="noopener noreferrer">API keys</a> for your site. Also check our <a href="%3$s" target="_blank" rel="noopener noreferrer">documentation.</a>', 'avia_framework'), $recaptcha, $recaptcha_admin, $recaptcha_doc) . '<br />';
    $recaptcha_v3 = sprintf(__('Please keep in mind that Version 3 needs to <a href="%1$s" target="_blank" rel="noopener noreferrer">monitor user behaviour and collects user data</a>. In case the score does not recognize a human Version 2 checkbox will be used additionally for verification. Therefore you must also register V2 keys.', 'avia_framework'), $recaptcha_v3);
    $recaptcha_score = __('A score of 1.0 is very likely a good interaction, 0.0 is very likely a bot. Google recommends a threshold of 0.5 by default. In case we encounter a non human we ask user to verify with Version 2 chckbox.', 'avia_framework');

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Google ReCAPTCHA', 'avia_framework'),
        'desc' => $recaptcha_desc,
        'id' => 'avia_recaptcha',
        'std' => '',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Select if you want to use Google reCAPTCHA', 'avia_framework'),
        'desc' => $recaptcha_v3,
        'id' => 'avia_recaptcha_version',
        'type' => 'select',
        'no_first' => true,
        'std' => '',
        'subtype' => array(
            __('Disable reCAPTCHA', 'avia_framework') => '',
            __('reCAPTCHA Version 2', 'avia_framework') => 'avia_recaptcha_v2',
            __('reCAPTCHA Version 3 (needs V2 as fallback verification)', 'avia_framework') => 'avia_recaptcha_v3',
        )
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Site Key Version 2', 'avia_framework'),
        'desc' => __('Enter the reCAPTCHA v2 API site key here.', 'avia_framework'),
        'id' => 'avia_recaptcha_pkey_v2',
        'type' => 'text',
        'required' => array('avia_recaptcha_version', '{contains_array}avia_recaptcha_v2;avia_recaptcha_v3'),
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Secret Key Version 2', 'avia_framework'),
        'desc' => __('Enter the reCAPTCHA v2 API secret key here.', 'avia_framework'),
        'id' => 'avia_recaptcha_skey_v2',
        'type' => 'text',
        'required' => array('avia_recaptcha_version', '{contains_array}avia_recaptcha_v2;avia_recaptcha_v3'),
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => '',
        'desc' => '',
        'id' => 'avia_recaptcha_key_verify_v2',
        'required' => array('avia_recaptcha_version', '{contains_array}avia_recaptcha_v2;avia_recaptcha_v3'),
        'type' => 'verification_field',
        'force_callback' => true,
        'input_ids' => array('avia_recaptcha_version', 'avia_recaptcha_pkey_v2', 'avia_recaptcha_skey_v2', 'avia_recaptcha_pkey_v3', 'avia_recaptcha_skey_v3'),
        'ajax' => 'av_recaptcha_api_check',
        'js_callback' => 'av_recaptcha_js_api_check',
        'class' => 'av_full_description',
        'button-label' => __('Check reCAPTCHA API Keys Version 2', 'avia_framework'),
        'button-relabel' => __(' Check reCAPTCHA API Keys Version 2', 'avia_framework'),
        'std' => ''
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Site Key Version 3', 'avia_framework'),
        'desc' => __('Enter the reCAPTCHA v3 API site key here.', 'avia_framework'),
        'id' => 'avia_recaptcha_pkey_v3',
        'type' => 'text',
        'required' => array('avia_recaptcha_version', 'avia_recaptcha_v3'),
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Secret Key Version 3', 'avia_framework'),
        'desc' => __('Enter the reCAPTCHA v3 API secret key here.', 'avia_framework'),
        'id' => 'avia_recaptcha_skey_v3',
        'type' => 'text',
        'required' => array('avia_recaptcha_version', 'avia_recaptcha_v3'),
    );

    $numbers = array();
    for ($i = 0; $i <= 10; $i++) {
        $numbers[number_format($i / 10.0, 1, ',', ' ')] = (string)$i;
    }

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => __('Select Score For Human', 'avia_framework'),
        'desc' => $recaptcha_score,
        'id' => 'avia_recaptcha_score',
        'type' => 'select',
        'no_first' => true,
        'std' => '5',
        'required' => array('avia_recaptcha_version', 'avia_recaptcha_v3'),
        'subtype' => $numbers
    );

    /**
     * @used_by                av_google_recaptcha
     * @since 4.6.2
     */
    if (current_theme_supports('avia_recaptcha_show_legal_information')) {
        $desc = __('Select if you want to show the default Google badge or only a message below the submit button. This is mandatory if you want to use V3.', 'avia_framework');
        $desc .= ' <a href="https://developers.google.com/recaptcha/docs/faq#id-like-to-hide-the-recaptcha-badge-what-is-allowed" target="_blank" rel="noopener noreferrer">' . __('See Google documentation', 'avia_framework') . '</a>.';

        $avia_elements[] = array(
            'slug' => 'google',
            'name' => __('Google Legal Information', 'avia_framework'),
            'desc' => $desc,
            'id' => 'avia_recaptcha_badge',
            'type' => 'select',
            'no_first' => true,
            'std' => 'contact_only_message',
            'required' => array('avia_recaptcha_version', 'avia_recaptcha_v3'),
            'subtype' => array(
                __('Show default Google badge on all pages', 'avia_framework') => '',
                __('Show a message string on contact form page instead', 'avia_framework') => 'message',
                __('Show message string on contact form page only, hide badge on other pages', 'avia_framework') => 'contact_only_message',
                __('Hide badge and string completely on every page', 'avia_framework') => 'hide'
            ),
        );
    } else {
        $desc = '<strong>' . __('Google Legal Information - for developers', 'avia_framework') . '</strong><br />';
        $desc .= __('If you want to change the default behaviour you can display a select box by adding to functions.php:', 'avia_framework') . '<br />';
        $desc .= 'add_theme_support( "avia_recaptcha_show_legal_information" );';

        $avia_elements[] = array(
            'name' => '',
            'desc' => $desc,
            'id' => 'avia_recaptcha_legal_description',
            'std' => '',
            'slug' => 'google',
            'type' => 'heading',
            'nodescription' => true
        );

        $avia_elements[] = array(
            'slug' => 'google',
            'std' => 'contact_only_message',
            'name' => __('Google Legal Information - hidden - uses default value', 'avia_framework'),
            'desc' => '',
            'id' => 'avia_recaptcha_badge',
            'type' => 'hidden',
        );
    }

    $avia_elements[] = array(
        'slug' => 'google',
        'name' => '',
        'desc' => '',
        'id' => 'avia_recaptcha_key_verify_v3',
        'required' => array('avia_recaptcha_version', 'avia_recaptcha_v3'),
        'type' => 'verification_field',
        'force_callback' => true,
        'input_ids' => array('avia_recaptcha_version', 'avia_recaptcha_pkey_v2', 'avia_recaptcha_skey_v2', 'avia_recaptcha_pkey_v3', 'avia_recaptcha_skey_v3'),
        'ajax' => 'av_recaptcha_api_check',
        'js_callback' => 'av_recaptcha_js_api_check',
        'class' => 'av_full_description',
        'button-label' => __('Check reCAPTCHA API Keys V3', 'avia_framework'),
        'button-relabel' => __(' Check reCAPTCHA API Keys V3', 'avia_framework'),
        'std' => ''
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'std' => '',
        'name' => __('Last verified keys - hidden - used for internal use only', 'avia_framework'),
        'desc' => '',
        'id' => 'recaptcha_verified_keys_v2',
        'type' => 'hidden',
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'std' => '',
        'name' => __('Last verified keys - hidden - used for internal use only', 'avia_framework'),
        'desc' => '',
        'id' => 'recaptcha_verified_keys_v3',
        'type' => 'hidden',
    );

    $avia_elements[] = array(
        'slug' => 'google',
        'type' => 'visual_group_end',
        'id' => 'avia_google_recaptcha_group_end',
        'nodescription' => true
    );

    /**
     * Privacy section
     *
     * @author kriesi
     * @since 4.4
     */

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Privacy and Cookies', 'avia_framework'),
        'desc' => '',
        'id' => 'avia_p_and_c',
        'std' => '',
        'type' => 'heading',
        'nodescription' => true
    );


//START TAB CONTAINER
    $avia_elements[] = array(
        "slug" => "cookie",
        "type" => "visual_group_start",
        "id" => "avia_cookietab1",
        "nodescription" => true,
        'class' => 'avia_tab_container avia_set'
    );

// Start TAB
    $avia_elements[] = array(
        "slug" => "cookie",
        "type" => "visual_group_start",
        "id" => "avia_cookietab5",
        "nodescription" => true,
        'class' => 'avia_tab avia_tab2',
        'name' => __('Privacy Policy', 'avia_framework')
    );


    $eu_msg = __("In case you deal with any EU customers/visitors these options allow you to make your site GDPR compliant.", 'avia_framework') . '<br />';
    $eu_msg .= __("The following default text will be applied if you leave the textfields empty:", 'avia_framework') . '<br />';
    $eu_msg .= '<p><strong>' . av_privacy_class::get_default_privacy_message() . '</strong></p>';

    $avia_elements[] = array(
        "name" => __("Privacy Policy", 'avia_framework'),
        "desc" => $eu_msg,
        "id" => "gdpr_overveiw",
        "std" => "",
        "slug" => "cookie",
        "type" => "heading",
        "nodescription" => true);


    $policy_page_wp = get_option('wp_page_for_privacy_policy');
    if (empty($policy_page_wp)) {
        global $wp_version;

        //remove any beta tags from version string
        $clean_version = explode('-', $wp_version);
        $clean_version = $clean_version[0];

        $notice_class = ' av-text-notice';
        $notice_msg = __("Attention: You need to set a Privacy Policy page here to activate these features:", 'avia_framework') . ' <a target="_blank" href="' . admin_url('privacy.php') . '">' . __("Set Privacy Policy", 'avia_framework') . '</a>';


        if (version_compare($clean_version, '4.9.6', '<')) {
            $notice_class = ' av-text-notice av-notice-error';
            $notice_msg = __("Attention: You need WordPress version 4.9.6 or higher to use these features", 'avia_framework');
        }

        $avia_elements[] = array(
            "desc" => "<br><strong class='{$notice_class} av-prev-el-notice'>" . $notice_msg . '</strong>',
            "id" => "privacy_activate",
            "std" => "",
            "slug" => "cookie",
            "type" => "heading",
            "nodescription" => true);
    } else /******************************** PRIVACY PAGE ACTIVE *****************************************/ {

        $desc = __("A short message that can be displayed below forms, along with a checkbox, that lets the user know that he has to agree to your privacy policy in order to send the form. See default text above if you leave empty.", 'avia_framework');

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Append a privacy policy message to your comment form?", 'avia_framework'),
            "desc" => __("Check to append a message to the comment form for unregistered users. Commenting without consent is no longer possible", 'avia_framework'),
            "id" => "privacy_message_commentform_active",
            "type" => "checkbox",
            "std" => false,
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Message below comment form", 'avia_framework'),
            "desc" => $desc,
            "id" => "privacy_message",
            "type" => "textarea",
            "class" => "av_small_textarea",
            "std" => '',
            "required" => array("privacy_message_commentform_active", 'privacy_message_commentform_active'),
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Append a privacy policy message to template builder contact forms?", 'avia_framework'),
            "desc" => __("Check to append a message to all of your contact forms.", 'avia_framework'),
            "id" => "privacy_message_contactform_active",
            "type" => "checkbox",
            "std" => false,
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Message below template builder contact forms", 'avia_framework'),
            "desc" => $desc,
            "id" => "privacy_message_contact",
            "type" => "textarea",
            "class" => "av_small_textarea",
            "std" => '',
            "required" => array("privacy_message_contactform_active", 'privacy_message_contactform_active'),
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Append a privacy policy message to mailchimp contact forms?", 'avia_framework'),
            "desc" => __("Check to append a message to all of your mailchimp forms.", 'avia_framework'),
            "id" => "privacy_message_mailchimp_active",
            "type" => "checkbox",
            "std" => false,
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Message below mailchimp subscription forms", 'avia_framework'),
            "desc" => $desc,
            "id" => "privacy_message_mailchimp",
            "type" => "textarea",
            "class" => "av_small_textarea",
            "std" => '',
            "required" => array("privacy_message_mailchimp_active", 'privacy_message_mailchimp_active'),
        );


        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Append a privacy policy message to your login forms?", 'avia_framework'),
            "desc" => __("Check to append a message to the default login forms.", 'avia_framework'),
            "id" => "privacy_message_login_active",
            "type" => "checkbox",
            "std" => false,
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Message below login forms", 'avia_framework'),
            "desc" => $desc,
            "id" => "privacy_message_login",
            "type" => "textarea",
            "class" => "av_small_textarea",
            "std" => '',
            "required" => array("privacy_message_login_active", 'privacy_message_login_active'),
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Append a privacy policy message to your registration forms?", 'avia_framework'),
            "desc" => __("Check to append a message to the default registrations forms.", 'avia_framework'),
            "id" => "privacy_message_registration_active",
            "type" => "checkbox",
            "std" => false,
        );

        $avia_elements[] = array(
            "slug" => "cookie",
            "name" => __("Message below registration forms", 'avia_framework'),
            "desc" => $desc,
            "id" => "privacy_message_registration",
            "type" => "textarea",
            "class" => "av_small_textarea",
            "std" => '',
            "required" => array("privacy_message_registration_active", 'privacy_message_registration_active'),
        );


// END TAB
        $avia_elements[] = array(
            'slug' => 'cookie',
            'type' => 'visual_group_end',
            'id' => 'avia_tab5_end',
            'nodescription' => true
        );

// Start TAB
        $avia_elements[] = array(
            'slug' => 'cookie',
            'type' => 'visual_group_start',
            'id' => 'avia_cookietab5',
            'nodescription' => true,
            'class' => 'avia_tab avia_tab2',
            'name' => __('Privacy Shortcodes', 'avia_framework')
        );

        $pp_id = get_option('wp_page_for_privacy_policy');
        $pp_url = admin_url("post.php?post={$pp_id}&action=edit");
        $pp_title = get_the_title($pp_id);

        $avia_elements[] = array(
            "name" => __("Shortcodes you can use in your Privacy Policy", 'avia_framework') . " - <a target='_blank' href='{$pp_url}'>({$pp_title})</a>",
            "desc" => __("In order to offer your users a better experience you can use the shortcodes listed here in your privacy policy. These shortcodes allow your users to change certain behavior of your website.", 'avia_framework') .
                "<ul>" .
                "<li><strong>[av_privacy_allow_cookies]</strong> - " . __(" allows a user to refuse cookies and hides message bar (needs 2 cookies for that, others are removed)", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_accept_essential_cookies]</strong> - " . __(" allows a user to opt out from essential theme and all other cookies (except 2 from av_privacy_allow_cookies)", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_google_tracking]</strong> - " . __(" allows a user to disable Google tracking in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_google_webfonts]</strong> - " . __(" allows a user to disable the use of Google webfonts in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_google_recaptcha]</strong> - " . __(" allows a user to disable the use of Google reCaptcha in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_google_maps]</strong> - " . __(" allows a user to disable the use of Google Maps in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_video_embeds]</strong> - " . __(" allows a user to disable video embeds in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_custom_cookie cookie_name='']</strong> - " . __(" allows a user to disable custom cookies (see options below) in his or her browser", 'avia_framework') . "</li>" .
                "<li><strong>[av_privacy_link]</strong> - " . __(" displays a link to the privacy policy page set in your WordPress admin panel or to a custom page", 'avia_framework') . "</li>" .
//"<li><strong>[av_privacy_google_webfonts]</strong> - ".__(" allows a user to disable the use of google webfonts",'avia_framework')."</li>".
                "</ul><br>" .
                __("Please note: if you do not like the default text that is displayed by those shortcodes you can change it by using [shortcode]Your text here[/shortcode]", 'avia_framework') .
                '<br /><br />' .
                '<ul>' .

                '<li><strong>[av_privacy_cookie_info id="" class=""]</strong> - ' . __(' adds a list about used and accessable cookies in domain with value and additional info about the cookie', 'avia_framework') . '</li>' .
                '<li><strong>[av_privacy_accept_button wrapper_class="" id="" class=""]your button text[/av_privacy_accept_button]</strong> - ' . __(' adds an accept cookies button', 'avia_framework') . '</li>' .
                '<li><strong>[av_privacy_accept_all_button wrapper_class="" id="" class=""]your button text[/av_privacy_accept_all_button]</strong> - ' . __(' adds an accept all cookies and services button', 'avia_framework') . '</li>' .
                '<li><strong>[av_privacy_do_not_accept_button wrapper_class="" id="" class=""]your button text[/av_privacy_do_not_accept_button]</strong> - ' . __(' adds a do not accept cookies button', 'avia_framework') . '</li>' .
                '<li><strong>[av_privacy_modal_popup_button wrapper_class="" id="" class=""]your button text[/av_privacy_modal_popup_button]</strong> - ' . __(' adds a button that opens the privacy modal popup window - you have to enable cookie consent message bar', 'avia_framework') . '</li>' .
                '</ul><br>',
            "id" => "gdpr_shortcodes",
            "std" => "",
            "slug" => "cookie",
            "type" => "heading",
            "nodescription" => true
        );


    }


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_tab5_end',
        'nodescription' => true
    );


// Start TAB
    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookietab5',
        'nodescription' => true,
        'class' => 'avia_tab avia_tab2',
        'name' => __('Cookie Handling', 'avia_framework')
    );


    $cookie_desc = '';
    $cookie_desc .= __("Make sure you comply with the <a target='_blank' href='http://ec.europa.eu/ipg/basics/legal/cookies/index_en.htm' rel='noopener noreferrer'>EU cookie law</a> by informing users that your site uses cookies. This can be done with a small notification bar or modal popup window", 'avia_framework');
    $cookie_desc .= '<br><br>';
    $cookie_desc .= __('You can also use the message bar to display a one time message not related to cookies if you do not need to inform your customers about the use of cookies.', 'avia_framework') . ' ';
    $cookie_desc .= '<br><br>';
    $cookie_desc .= __('More detailed information about the cookie law, message bar usage, the styling of the bar and more can be found in our documentation: ', 'avia_framework') . '<br><a href="https://kriesi.at/documentation/enfold/privacy-cookies/" target="_blank" rel="noopener noreferrer">' . __('Enfold Privacy And Cookies', 'avia_framework') . '</a>.';
    $cookie_desc .= '<br><br>';
    $cookie_desc .= '<strong>' . __('Using a caching plugin: Whenever you make changes here please clear server cache to allow a rebuild of the pages to reflect the changed options.', 'avia_framework') . '</strong>';

    $avia_elements[] = array(
        'name' => __('Cookie Handling and Cookie Consent Messages', 'avia_framework'),
        'desc' => $cookie_desc,
        'id' => 'overlay_description',
//			'class'	=> 'avia_heading_boxed',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );


    /***************************************************************************************************/
    /**
     * Cookie Consent section
     *
     * @author tinabillinger
     * @since 4.3
     * @since 4.5.7.2 extended by Günter
     */

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Enable cookie consent messages', 'avia_framework'),
        'desc' => __('Enable cookie consent messages to use message bar and modal popup.', 'avia_framework'),
        'id' => 'cookie_consent',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Disable cookie consent messages', 'avia_framework') => '',
            __('Enable cookie consent messages', 'avia_framework') => 'cookie_consent'
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Default Cookie Behaviour', 'avia_framework'),
        'desc' => __('Select how cookies and privacy options should be loaded by default for new visitors. Please remember that it is the responsibility of the website owner to fulfill the local rules for data privacy.', 'avia_framework'),
        'id' => 'cookie_default_settings',
        'type' => 'select',
        'required' => array('cookie_consent', '{contains_array}cookie_consent;cookie__consent_no_bar'),
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('All cookies and services are accepted on first page load, user can opt out', 'avia_framework') => '',
            __('User must accept and can opt out, all selected by default', 'avia_framework') => 'can_opt_out',
            __('User must accept and must opt in, only essential cookies selected', 'avia_framework') => 'needs_opt_in',
            __('Essential cookies are accepted on first page load, user must opt in', 'avia_framework') => 'essential_only',
        )
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookielink_group_start',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent;message_bar'),
    );

    $avia_elements[] = array(
        'name' => __('Cookie Consent Message Bar', 'avia_framework'),
        'desc' => __('Define content and buttons for your message bar to inform users about the use of cookies and services and depending on your country laws to opt in or opt out for services and cookies. If you make changes to message text or button label the message bar will be show again.', 'avia_framework'),
        'id' => 'consent_msg_bar_headline',
//			'class'	=> 'avia_heading_boxed',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Message', 'avia_framework'),
        'desc' => __('Provide a message which indicates that your site uses cookies.', 'avia_framework'),
        'id' => 'cookie_content',
        'type' => 'textarea',
        'std' => __('This site uses cookies. By continuing to browse the site, you are agreeing to our use of cookies.', 'avia_framework')
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Message Bar Position', 'avia_framework'),
        'desc' => __('Where on the page should the message bar appear?', 'avia_framework'),
        'id' => 'cookie_position',
        'type' => 'select',
        'std' => 'bottom',
        'no_first' => true,
        'subtype' => array(
            __('Top', 'avia_framework') => 'top',
            __('Bottom', 'avia_framework') => 'bottom',
            __('Top Left Corner', 'avia_framework') => 'top-left',
            __('Top Right Corner', 'avia_framework') => 'top-right',
            __('Bottom Left Corner', 'avia_framework') => 'bottom-left',
            __('Bottom Right Corner', 'avia_framework') => 'bottom-right',
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_button_group_start',
//			'class' => 'avia_boxed_visual_group',
        'nodescription' => true,
    );

    $avia_elements[] = array(
        'name' => __('Buttons', 'avia_framework'),
        'desc' => __('You can create any number of buttons/links for your message bar here:', 'avia_framework'),
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_button_group_end',
        'nodescription' => true,
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_button_group_def_start',
//			'class' => 'avia_boxed_visual_group',
        'nodescription' => true,
    );

    $avia_elements[] = array(
        'type' => 'group',
        'id' => 'msg_bar_buttons',
        'slug' => 'cookie',
        'linktext' => '+',
        'deletetext' => '×',
        'blank' => true,
        'nodescription' => true,
        'std' => array(
            array(
                'msg_bar_button_label' => __('Accept settings', 'avia_framework'),
                'msg_bar_button_action' => '',
                'msg_bar_button_tooltip' => __('Allow to use cookies, you can modify used cookies in settings', 'avia_framework')
            ),
            array(
                'msg_bar_button_label' => __('Hide notification only', 'avia_framework'),
                'msg_bar_button_action' => 'hide_notification',
                'msg_bar_button_tooltip' => __('Do not allow to use cookies - some functionality on our site might not work as expected.', 'avia_framework')
            ),
            array(
                'msg_bar_button_label' => __('Settings', 'avia_framework'),
                'msg_bar_button_action' => 'info_modal',
                'msg_bar_button_tooltip' => __('Get more info about cookies and select which one you want to allow or not.', 'avia_framework'),
            ),
        ),
        'subelements' => array(
            array(
                'name' => __('Button Label', 'avia_framework'),
                'desc' => '',
                'id' => 'msg_bar_button_label',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_1'
            ),

            array(
                'name' => __('Button Action', 'avia_framework'),
                'desc' => '',
                'id' => 'msg_bar_button_action',
                'type' => 'select',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_2',
                'no_first' => true,
                'subtype' => array(
                    __('Accept settings and dismiss notification', 'avia_framework') => '',
                    __('Accept all cookies and services, dismiss notification', 'avia_framework') => 'select_all',
                    __('Do not accept and hide notification', 'avia_framework') => 'hide_notification',
                    __('Open info modal on privacy and cookies', 'avia_framework') => 'info_modal',
                    __('Link to another page', 'avia_framework') => 'link',
                )
            ),

            array(
                'name' => __('Button Link', 'avia_framework'),
                'desc' => '',
                'id' => 'msg_bar_button_link',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_3',
                'required' => array('msg_bar_button_action', '{contains}link')
            ),

            array(
                'name' => __('Button Tooltip', 'avia_framework'),
                'desc' => __('Enter an additional tooltip to give a closer information about use of the button', 'avia_framework'),
                'id' => 'msg_bar_button_tooltip',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => ''
            ),
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_button_group_def_end',
        'nodescription' => true,
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookielink_group_end',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent;message_bar'),
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_modal_window_start',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent;cookie__consent_no_bar;message_bar')
    );

    $desc = __('Define a modal popup window to inform visitors about your privacy policy and to opt in or out of services and cookies.', 'avia_framework');
    $desc .= '<br /><br />';
    $desc .= __('By default we use the built in lightbox to show the popup. If you want to use your own lightbox you can assign a js wrapper function to avia_cookie_consent_modal_callback (see file enfold\js\avia-snippet-cookieconsent.js) to activate yours.', 'avia_framework');

    $avia_elements[] = array(
        'name' => __('Modal Popup Window', 'avia_framework'),
        'desc' => $desc,
        'id' => 'modal_popup_window_headline',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'name' => __('Display Modal Popup Actions', 'avia_framework'),
        'desc' => __('Select how to display your modal popup window. Country law regulation might enforce you to show the popup on first page load. If user does not accept cookies he will be prompted every time when opening a new window or tab.', 'avia_framework'),
        'id' => 'modal_popup_window_action',
        'type' => 'select',
        'slug' => 'cookie',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Open with a button only', 'avia_framework') => '',
            __('Open immediately on pageload', 'avia_framework') => 'page_load',
        )
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_button_group_start',
//			'class' => 'avia_boxed_visual_group',
        'nodescription' => true,
    );


    $avia_elements[] = array(
        'type' => 'group',
        'id' => 'modal_popup_window_buttons',
        'slug' => 'cookie',
        'linktext' => '+',
        'deletetext' => '×',
        'blank' => true,
        'nodescription' => true,
        'std' => array(
            array(
                'modal_popup_button_label' => __('Accept settings', 'avia_framework'),
                'modal_popup_button_action' => '',
                'modal_popup_button_tooltip' => __('Allow to use cookies, you always can modify used cookies and services', 'avia_framework')
            ),
            array(
                'modal_popup_button_label' => __('Hide notification only', 'avia_framework'),
                'modal_popup_button_action' => 'hide_notification',
                'modal_popup_button_tooltip' => __('Do not allow to use cookies or services - some functionality on our site might not work as expected.', 'avia_framework')
            )
        ),
        'subelements' => array(

            array(
                'name' => __('Button Label', 'avia_framework'),
                'desc' => '',
                'id' => 'modal_popup_button_label',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_1'
            ),

            array(
                'name' => __('Button Action', 'avia_framework'),
                'desc' => '',
                'id' => 'modal_popup_button_action',
                'type' => 'select',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_2',
                'no_first' => true,
                'subtype' => array(
                    __('Accept settings and dismiss notification', 'avia_framework') => '',
                    __('Accept all cookies and services, dismiss notification', 'avia_framework') => 'select_all',
                    __('Do not accept and hide notification', 'avia_framework') => 'hide_notification',
                    __('Link to another page', 'avia_framework') => 'link',
                )
            ),

            array(
                'name' => __('Button Link', 'avia_framework'),
                'desc' => '',
                'id' => 'modal_popup_button_link',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_3columns av_col_3',
                'required' => array('modal_popup_button_action', '{contains}link')
            ),

            array(
                'name' => __('Button Tooltip', 'avia_framework'),
                'desc' => __('Enter an additional tooltip to give a closer information about use of the button', 'avia_framework'),
                'id' => 'modal_popup_button_tooltip',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => ''
            ),
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_custom_content_end',
        'nodescription' => true,
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Modal Window Custom Content', 'avia_framework'),
        'desc' => __('Instead of displaying the default content set custom content yourself.', 'avia_framework'),
        'id' => 'cookie_info_custom_content',
        'type' => 'checkbox',
        'std' => false,
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_custom_content_start',
        'nodescription' => true,
        'required' => array('cookie_info_custom_content', 'cookie_info_custom_content')
    );

    $desc = __('Define content of your modal popup window to inform visitors about your privacy policy. Use shortcodes to add toggles so visitors can opt in or out of services and cookies.', 'avia_framework');
    $desc .= '<br /><br />';
    $desc .= '<strong>';
    $desc .= __('If you want to allow your visitors to opt out of essential cookies and hide the message bar when returning to your site you need to add the following 2 shortcodes to your content:', 'avia_framework');
    $desc .= '</strong>';
    $desc .= '<ul>';
    $desc .= '<li><strong>[av_privacy_allow_cookies]</strong> - ' . __('allows a user to refuse cookies and hides message bar (needs 2 cookies for that, others are removed)', 'avia_framework') . '</li>';
    $desc .= '<li><strong>[av_privacy_accept_essential_cookies]</strong> - ' . __('allows a user to opt out from essential theme and all other cookies (except 2 from av_privacy_allow_cookies)', 'avia_framework') . '</li>';
    $desc .= '</ul>';


    $avia_elements[] = array(
        'name' => __('Modal Popup Window Content', 'avia_framework'),
        'desc' => $desc,
        'id' => 'modal_popup_window_content_headline',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'name' => __('Main Heading', 'avia_framework'),
        'desc' => '',
        'id' => 'cookie_info_content_heading',
        'type' => 'text',
        'slug' => 'cookie',
        'std' => 'Cookie and Privacy Settings',
    );


    $contents = av_privacy_helper()->get_default_modal_popup_content('no_filter');

    $avia_elements[] = array(
        "type" => "group",
        "id" => "cookie_info_content",
        "slug" => "cookie",
        "linktext" => "+",
        "deletetext" => "×",
        "blank" => true,
        "nodescription" => true,
        "std" => $contents,
        'subelements' => array(

            array(
                "name" => __("Tab Label", 'avia_framework'),
                "desc" => "",
                "id" => "label",
                "type" => "text",
                "slug" => "cookie",
                "class" => "av_2columns av_col_1"),

            array(
                "name" => __("Tab Content", 'avia_framework'),
                "desc" => "",
                "id" => "content",
                "type" => "textarea",
                "slug" => "cookie",
                "class" => "av_2columns av_col_2",
            ))
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_custom_content_end',
        'nodescription' => true,
        'required' => array('cookie_info_custom_content', 'cookie_info_custom_content')
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_modal_window_end',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent;cookie__consent_no_bar;message_bar')
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_advanced_options_start',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent')
    );


    $avia_elements[] = array(
        'name' => __('Advanced Options', 'avia_framework'),
        'desc' => '',
        'id' => 'cookie_advanced_options_headline',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
//			'class' => 'avia_boxed_visual_group',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Show advanced options', 'avia_framework'),
        'desc' => __('Contains options for special use cases like using the message bar just for simple notifications', 'avia_framework'),
        'id' => 'cookie_show_advanced_options',
        'type' => 'checkbox',
        'std' => false,
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_advanced_start',
        'nodescription' => true,
        'required' => array('cookie_show_advanced_options', '{contains_array}cookie_show_advanced_options')
    );

    $desc = __('Select if you want to use cookie logic or only display one time messages to your visitor but do not need the cookie logic. The message bar pops up again whenever you change the displayed text or button labels.', 'avia_framework');
    $desc .= '<br /><br />';
    $desc .= __('To use cookie logic without showing a message bar please check our documentation:', 'avia_framework') . ' <a href="https://kriesi.at/documentation/enfold/privacy-cookies/#notification-bar" target="_blank" rel="noopener noreferrer">' . __('Enfold Privacy And Cookies', 'avia_framework') . '</a>.';

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Select use of the message bar', 'avia_framework'),
        'desc' => $desc,
        'id' => 'cookie_message_bar_only',
        'required' => array('cookie_show_advanced_options', '{contains_array}cookie_show_advanced_options'),
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Display message bar and use cookie logic', 'avia_framework') => '',
            __('Use as a simple message bar without cookie logic', 'avia_framework') => 'cookie_message_bar_only bottom',
        )
    );

//
//if( current_theme_supports( 'avia_gdpr_permanent_hide_message_bar' ) )
//{
//	$avia_elements[] = array(
//				'slug'	=> 'cookie',
//				'name'	=> __( 'Hide Message Bar permanently', 'avia_framework' ),
//				'desc'	=> __( 'Select if you want to use the implemented cookie logic and allow visitors to opt in or opt out of cookies and services but only want to provide a custom settings page.', 'avia_framework' ),
//				'id'	=> 'cookie_consent_no_bar',
//				'type'	=> 'select',
//				'std'	=> '',
//				'no_first'	=> true,
//				'subtype'	=> array(
//									__( 'Display message bar', 'avia_framework' )		=> '',
//									__( 'Hide Message Bar permanently', 'avia_framework' )	=> 'cookie_consent_no_bar',
//								)
//			);
//
//	$requ_cookie_consent_no_bar = array( 'cookie_consent_no_bar', '' );
//}


    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Show reopen badge', 'avia_framework'),
        'desc' => __('Select to show a badge to reopen the message bar', 'avia_framework'),
        'id' => 'cookie_consent_badge',
//			'required'	=> array( 'cookie_consent_no_bar', '' ),
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Disable badge', 'avia_framework') => '',
            __('Show badge at the bottom left of the screen', 'avia_framework') => 'left bottom',
            __('Show badge at the bottom right of the screen', 'avia_framework') => 'right bottom'
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_message_bar_start',
        'nodescription' => true,
        'required' => array('cookie_message_bar_only', '')
    );

    $desc = __('Select to force a reload of the page when user clicks the &quot;Accept Settings....&quot; or &quot;Do not accept....&quot; button. If you do not use external services a page reload is usually not necessary.', 'avia_framework');

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Auto Reload Page', 'avia_framework'),
        'desc' => $desc,
        'id' => 'cookie_auto_reload',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('No auto reload required', 'avia_framework') => '',
            __('Auto reload on &quot;Accept Settings ...&quot; only', 'avia_framework') => 'reload_accept',
            __('Auto reload on &quot;Do not accept ...&quot; only', 'avia_framework') => 'reload_no_accept',
            __('Auto reload on both buttons', 'avia_framework') => 'reload_both'
        )
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'name' => __('Refuse Cookie Warning', 'avia_framework'),
        'desc' => __('Provide a short message for a browser alert when user clicks the &quot;Do not accept and hide notification&quot; button. Inform him that refusing cookies will show the message bar every time he opens a new window or tab. Leave empty if you do not want to show the browser alert.', 'avia_framework'),
        'id' => 'cookie_refuse_button_alert',
        'type' => 'textarea',
        'std' => __("When refusing all cookies this site might not be able to work as expected. Please check our settings page and opt out for cookies or functions you do not want to use and accept cookies. You will be shown this message every time you open a new window or a new tab.\n\nAre you sure you want to continue?", 'avia_framework')
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_start',
        'id' => 'avia_cookie_custom_cookies_start',
        'nodescription' => true,
    );


    $desc = __('Define additional custom cookies set by plugins. There are browser security limitations and it might not be possible to remove them using JavaScript or PHP.', 'avia_framework') . ' ';
    $desc .= __('Cookies must be in the same domain and you need to specify the name and the path (case sensitive) that is shown in the developer tools of your browser. Please see <a href="https://kriesi.at/documentation/enfold/privacy-cookies/#additional-custom-cookies">Additional Custom Cookies</a> on our documentation.', 'avia_framework');
    $desc .= '<br /><br />';
    $desc .= __('To add a toggle for that cookie use the following shortcodes:', 'avia_framework');
    $desc .= '<br /><br />';
    $desc .= '<strong>' . __('[av_privacy_custom_cookie cookie_name=""]', 'avia_framework') . '</strong>';
    $desc .= '<br />';
    $desc .= '<strong>' . __('[av_privacy_custom_cookie cookie_name=""]Your text here[/av_privacy_custom_cookie] ', 'avia_framework') . '</strong>';

    $avia_elements[] = array(
        'name' => __('Additional Custom Cookies', 'avia_framework'),
        'desc' => $desc,
        'id' => 'cookie_custom_cookies_headline',
        'std' => '',
        'slug' => 'cookie',
        'type' => 'heading',
        'nodescription' => true
    );

    $avia_elements[] = array(
        'type' => 'group',
        'id' => 'custom_cookies',
        'slug' => 'cookie',
        'linktext' => '+',
        'deletetext' => '×',
        'blank' => true,
        'nodescription' => true,
        'std' => array(
            array(
                'cookie_name' => '',
                'cookie_path' => '',
                'cookie_content' => '',
                'cookie_info_desc' => '',
                'cookie_compare_action' => ''
            )
        ),
        'subelements' => array(
            array(
                'name' => __('Cookie Name', 'avia_framework'),
                'desc' => '',
                'id' => 'cookie_name',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_2columns av_col_1'
            ),
            array(
                'name' => __('Cookie Path', 'avia_framework'),
                'desc' => '',
                'id' => 'cookie_path',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_2columns av_col_2'
            ),
            array(
                'name' => __('Description For Toggle', 'avia_framework'),
                'desc' => '',
                'id' => 'cookie_content',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_2columns av_col_1'
            ),
            array(
                'name' => __('Description For Cookie Info List', 'avia_framework'),
                'desc' => '',
                'id' => 'cookie_info_desc',
                'type' => 'text',
                'slug' => 'cookie',
                'class' => 'av_2columns av_col_2'
            ),
            array(
                'name' => __('Compare Action', 'avia_framework'),
                'desc' => __('Select your compare action if you have to remove multiple cookies. Be carefull with contains as this removes all cookies that contain the string (except the disabled cookie).', 'avia_framework'),
                'id' => 'cookie_compare_action',
                'type' => 'select',
                'slug' => 'cookie',
                'std' => '',
                'no_first' => true,
                'subtype' => array(
                    __('Cookie equals cookie name', 'avia_framework') => '',
                    __('Cookie starts with cookie name', 'avia_framework') => 'starts_with',
                    __('Cookie contains cookie name', 'avia_framework') => 'contains'
                )
            )
        )
    );


    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_custom_cookies_end',
        'nodescription' => true,
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_message_bar_end',
        'nodescription' => true,
        'required' => array('cookie_message_bar_only', '')
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_advanced_end',
        'nodescription' => true,
        'required' => array('cookie_show_advanced_options', '{contains_array}cookie_show_advanced_options')
    );

    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_cookie_advanced_options_end',
        'nodescription' => true,
        'required' => array('cookie_consent', '{contains_array}cookie_consent')
    );


//END TAB
    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_tab5_end',
        'nodescription' => true
    );

//END TAB CONTAINER
    $avia_elements[] = array(
        'slug' => 'cookie',
        'type' => 'visual_group_end',
        'id' => 'avia_tab_container_end',
        'nodescription' => true
    );


    /*newsletter*/

    $avia_elements[] = array("name" => __("Newsletter via Mailchimp", 'avia_framework'),
        "desc" => __("Mailchimp allows you to easily use newsletter functionality with this theme. In order to use the Newsletter features you need to create a Mailchimp account and enter your API key into the field below.", 'avia_framework') . "<br/><br/><a href='https://admin.mailchimp.com/account/api' target='_blank' rel='noopener noreferrer'>" . __("You can find your API key here", 'avia_framework') . "</a>",
        "std" => "",
        "slug" => "newsletter",
        "type" => "heading",
        "nodescription" => true);

    $avia_elements[] = array(
        "slug" => "newsletter",
        "std" => "",
        "name" => __("Enter a valid Mailchimp API Key to use all newsletter related theme functions", 'avia_framework'),
        "help" => "",
        "desc" => false,
        "id" => "mailchimp_api",
        "type" => "verification_field",
        "ajax" => "av_mailchimp_check_ajax",
        "button-label" => __('Check API Key', 'avia_framework'),
        "button-relabel" => __('Check Key again & renew Lists', 'avia_framework')
    );

    $avia_elements[] = array(
        'slug' => 'newsletter',
        'std' => '',
        'name' => __('Last verified key - hidden - used for internal use only', 'avia_framework'),
        'desc' => '',
        'id' => 'mailchimp_verified_key',
        'type' => 'hidden',
    );


    /*shop*/

    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Header Shopping Cart Icon', 'avia_framework'),
        'desc' => __('You can choose the appearance of the cart icon here', 'avia_framework'),
        'id' => 'cart_icon',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Display Floating on the side, but only once product was added to the cart', 'avia_framework') => '',
            __('Always Display floating on the side', 'avia_framework') => 'always_display',
            __('Always Display attached to the main menu', 'avia_framework') => 'always_display_menu',
            __('Do not show at all', 'avia_framework') => 'no_cart'
        )
    );


    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Product layout on overview pages', 'avia_framework'),
        'desc' => __('You can choose the appearance of your products here', 'avia_framework'),
        'id' => 'product_layout',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Default', 'avia_framework') => '',
            __('Default without buttons', 'avia_framework') => 'no_button',
            __('Minimal (no borders or buttons)', 'avia_framework') => 'minimal',
            __('Minimal Overlay with centered text', 'avia_framework') => 'minimal-overlay',
        )
    );

    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Product gallery', 'avia_framework'),
        'desc' => __('You can choose the appearance of your product gallery here', 'avia_framework'),
        'id' => 'product_gallery',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Default enfold product gallery', 'avia_framework') => '',
            __('WooCommerce 3.0 product gallery', 'avia_framework') => 'wc_30_gallery',
        )
    );

    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Main Shop Page Banner', 'avia_framework'),
        'desc' => __('You can choose to display a parallax banner with description on the shop page', 'avia_framework'),
        'id' => 'shop_banner',
        'type' => 'select',
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('No, display no banner', 'avia_framework') => '',
            __('Yes, display a banner image', 'avia_framework') => 'av-active-shop-banner',
        )
    );

    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Shop Banner Image', 'avia_framework'),
        'desc' => __('Upload a large banner image which will be displayed as a background to the shop description', 'avia_framework'),
        'id' => 'shop_banner_image',
        'type' => 'upload',
        'required' => array('shop_banner', '{contains}av-active-shop-banner'),
        'label' => __('Use Image as banner', 'avia_framework')
    );

    $avia_elements[] = array(
        'slug' => 'shop',
        'name' => __('Shop Banner Image Color Overlay', 'avia_framework'),
        'desc' => __('Set a color to display a overlay above the banner image.', 'avia_framework'),
        'id' => 'shop_banner_overlay_color',
        'type' => 'colorpicker',
        'required' => array('shop_banner', '{contains}av-active-shop-banner'),
        'class' => 'av_2columns av_col_1',
        'std' => '#000000'
    );

    $avia_elements[] = array(
        "slug" => "shop",
        "required" => array('shop_banner', '{contains}av-active-shop-banner'),
        "class" => "av_2columns av_col_2",
        "name" => __("Overlay Opacity", 'avia_framework'),
        "desc" => __("Select the opacity of your colored banner overlay", 'avia_framework'),
        "id" => "shop_banner_overlay_opacity",
        "type" => "select",
        "std" => "0.5",
        "no_first" => true,
        "subtype" => array(
            '0.1' => '0.1',
            '0.2' => '0.2',
            '0.3' => '0.3',
            '0.4' => '0.4',
            '0.5' => '0.5',
            '0.6' => '0.6',
            '0.7' => '0.7',
            '0.8' => '0.8',
            '0.9' => '0.9',
            '1' => '1',

        ));


    $avia_elements[] = array(
        "slug" => "shop",
        "name" => __("Shop Description", 'avia_framework'),
        "desc" => __("Enter a short description or welcome note for your default Shop Page", 'avia_framework'),
        "id" => "shop_banner_message",
        "type" => "textarea",
        "required" => array('shop_banner', '{contains}av-active-shop-banner'),
        "class" => "av_2columns av_col_1",
    );

    $avia_elements[] = array(
        "slug" => "shop",
        "name" => __("Shop Description Color", 'avia_framework'),
        "desc" => __("Select the color of your shop description", 'avia_framework'),
        "id" => "shop_banner_message_color",
        "type" => "colorpicker",
        "required" => array('shop_banner', '{contains}av-active-shop-banner'),
        "class" => "av_2columns av_col_2",
        "std" => "#ffffff"
    );

    $avia_elements[] = array(
        "slug" => "shop",
        "name" => __("Enable Banner for product category pages", 'avia_framework'),
        "desc" => __("You can enable the shop banner for all categories as well. You can also set individual banners by editing the category", 'avia_framework'),
        "id" => "shop_banner_global",
        "type" => "checkbox",
        "required" => array('shop_banner', '{contains}av-active-shop-banner'),
        "std" => false,
    );


    /*layout*/


    $frontend_label = __("A rough preview of the frontend.", 'avia_framework');

    $avia_elements[] = array(
        "slug" => "layout",
        "id" => "default_layout_target",
        "type" => "target",
        "std" => "
					<style type='text/css'>
						.avprev-layout-container, .avprev-layout-container *{ 
							-moz-box-sizing: border-box;
							-webkit-box-sizing: border-box;
							box-sizing: border-box;
						}
						#boxed .avprev-layout-container{ padding:0 23px; border:1px solid #e1e1e1; background-color: #555;}
						#av-framed-box .avprev-layout-container{ padding:23px; border:1px solid #e1e1e1; background-color: #555;}
						.avprev-layout-container-inner{border:none; overflow: hidden;}
						.avprev-layout-container-inner{border: 1px solid #e1e1e1; background:#fff;}
						.avprev-layout-content-container{overflow:hidden; margin:0 auto; position:relative;}
						.avprev-layout-container-sizer{margin:0 auto; position:relative; z-index:5;}
						.avprev-layout-content-container .avprev-layout-container-sizer{display:table;}
						.avprev-layout-content-container .avprev-layout-container-sizer .av-cell{display:table-cell; padding: 20px;}
						.avprev-layout-content-container .avprev-layout-container-sizer:after{ background: #F8F8F8; position: absolute; top: 0; right: 99%; width: 100%; height: 100%; content: ''; z-index:1;}
						.avprev-layout-header{border-bottom:1px solid #e1e1e1; padding:20px; overflow: hidden;}
						.avprev-layout-slider{border-bottom:1px solid #e1e1e1; padding:30px 20px; background:#3B740F url('" . AVIA_IMG_URL . "layout/diagonal-bold-light.png') top right repeat; color:#fff;}
						.avprev-layout-content{border-left:1px solid #e1e1e1; width:73%; }
						.avprev-layout-sidebar{border-right:1px solid #e1e1e1; background:#f8f8f8; right:-1px; position:relative; min-height:141px;}
						.avprev-layout-menu-description{float:right;}
						.avprev-layout-menu{float:left; color:#999;}
						
						
						#header_right .avprev-layout-header{border-right:1px solid #e1e1e1; width:130px; float:left; border-bottom:none;}
						#header_left .avprev-layout-header{border-left:1px solid #e1e1e1; width:130px; float:right; border-bottom:none;}
						
						#header_right .avprev-layout-content-container{border-left:1px solid #e1e1e1; left:-1px;}
						#header_left  .avprev-layout-content-container{border-right:1px solid #e1e1e1; right:-1px;}
						
						#header_left .avprev-layout-menu, #header_right .avprev-layout-menu{float:none; padding-top:23px; clear:both; }
						#header_left .avprev-layout-divider, #header_right .avprev-layout-divider{display:none;}
						#header_left .avprev-layout-menuitem, #header_right .avprev-layout-menuitem{display:block; border-bottom:1px dashed #e1e1e1; padding:3px;}
						#header_left .avprev-layout-menuitem-first, #header_right .avprev-layout-menuitem-first{border-top:1px dashed #e1e1e1;}
						#header_left .avprev-layout-header .avprev-layout-container-sizer, #header_right .avprev-layout-header .avprev-layout-container-sizer{width:100%!important;}
						
						
						.avprev-layout-container-widget{display:none; border:1px solid #e1e1e1; padding:7px; font-size:12px; margin-top:5px; text-align:center;}
						.avprev-layout-container-social{margin-top:5px; text-align:center;}
						.av-active .pr-icons{display:block; }
						
						#header_left .avprev-layout-container-widget.av-active, #header_right .avprev-layout-container-widget.av-active{display:block;}
						#header_left .avprev-layout-container-social.av-active, #header_right .avprev-layout-container-widget.av-social{display:block;}
						
						#av-framed-box .avprev-layout-container-inner{border:none;}
						#boxed .avprev-layout-container-inner{border:none;}
						
					</style>

					<small class='live_bg_small'>{$frontend_label}</small>
					<div class='avprev-layout-container'>
						<div class='avprev-layout-container-inner'>
							<div class='avprev-layout-header'>
								<div class='avprev-layout-container-sizer'>
									<strong class='avprev-layout-menu-description'>لوگو + ناحیه منوی اصلی</strong>
									<div class='avprev-layout-menu'>
									<span class='avprev-layout-menuitem avprev-layout-menuitem-first'>خانه</span> 
									<span class='avprev-layout-divider'>|</span> 
									<span class='avprev-layout-menuitem'>درباره</span> 
									<span class='avprev-layout-divider'>|</span> 
									<span class='avprev-layout-menuitem'>تماس</span> 
									</div>
								</div>
								
								<div class='avprev-layout-container-social'>
									{$iconSpan}	
								</div>
								
								<div class='avprev-layout-container-widget'>
									<strong>ابزارک ها</strong>
								</div>
								
							</div>
							
							<div class='avprev-layout-content-container'>
								<div class='avprev-layout-slider'>
									<strong>ناحیه تمام عرض (برای مثال: اسلایدشو تمام عرض)</strong>
								</div>
							
								<div class='avprev-layout-container-sizer'>
									<div class='avprev-layout-content av-cell'><strong>ناحیه محتوا</strong><p>این ناحیه محتوا است. ناحیه محتوا، نوشته ها، برگه ها، محصولات و ... شما را شامل می شود.</p></div>
									<div class='avprev-layout-sidebar av-cell'><strong>ستون کناری</strong><p>این قسمت همه ی ابزارک های ستون کناری شما را شامل می شود.</p>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					

					",
        "nodescription" => true
    );

//START TAB CONTAINER
    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_start", "id" => "avia_tab_layout1", "nodescription" => true, 'class' => 'avia_tab_container avia_set');

    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_start", "id" => "avia_tab_layout5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Layout', 'avia_framework'));

    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Use stretched or boxed layout?", 'avia_framework'),
        "desc" => __("The stretched layout expands from the left side of the viewport to the right.", 'avia_framework'),
        "id" => "color-body_style",
        "type" => "select",
        "std" => "stretched",
        "class" => "av_2columns av_col_1",
        "no_first" => true,
        "target" => array("default_slideshow_target, #avia_default_layout_target::.avia_control_container::set_id"),
        "subtype" => array(__('Stretched layout', 'avia_framework') => 'stretched',
            __('Boxed Layout', 'avia_framework') => 'boxed',
            __('Fixed Frame', 'avia_framework') => 'av-framed-box'
        )
    );

    $numbers = array();
    for ($i = 1; $i <= 75; $i++) {
        $numbers[$i . "px"] = $i;
    }

    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Frame Width", 'avia_framework'),
        "desc" => __("Modify the frame color by changing the Body Background in", 'avia_framework') .
            " <a href='#goto_styling'>" .
            __("General Styling", 'avia_framework') .
            "</a>",
        "id" => "color-frame_width",
        "type" => "select",
        "std" => "20",
        "class" => "av_2columns av_col_2",
        "required" => array('color-body_style', '{contains}framed'),
        "no_first" => true,
        "subtype" => $numbers
    );


    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Logo and Main Menu", 'avia_framework'),
        "desc" => __("You can place your logo and main menu at the top of your site or within a sidebar", 'avia_framework'),
        "id" => "header_position",
        "type" => "select",
        "std" => "header_top",
        "class" => "av_2columns av_col_2",
        "target" => array("default_layout_target, #avia_default_slideshow_target::.avprev-layout-container, .avprev-design-container::set_id_single"),
        "no_first" => true,
        "subtype" => array(__('Top Header', 'avia_framework') => 'header_top',
            __('Left Sidebar', 'avia_framework') => 'header_left header_sidebar',
            __('Right Sidebar', 'avia_framework') => 'header_right header_sidebar',
        ));


    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Content Alignment", 'avia_framework'),
        "desc" => __("If the window width exceeds the maximum content width, where do you want to place your content", 'avia_framework'),
        "id" => "layout_align_content",
        "type" => "select",
        "std" => "content_align_center",
        "class" => "av_2columns av_col_1",
        "required" => array('header_position', '{contains}header_sidebar'),
        "no_first" => true,
        "subtype" => array(__('Center Content', 'avia_framework') => 'content_align_center',
            __('Position at the Left', 'avia_framework') => 'content_align_left',
            __('Position at the Right', 'avia_framework') => 'content_align_right',
        ));


    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Sticky Sidebar menu", 'avia_framework'),
        "desc" => __("You can choose if you want a sticky sidebar that does not scroll with the content", 'avia_framework'),
        "id" => "sidebarmenu_sticky",
        "type" => "select",
        "std" => "conditional_sticky",
        "class" => "av_2columns av_col_2",
        "required" => array('header_position', '{contains}header_left'),
        "no_first" => true,
        "subtype" => array(__('Sticky if Sidebar is smaller than the screen height, scroll otherwise', 'avia_framework') => 'conditional_sticky',
            __('Always Sticky', 'avia_framework') => 'always_sticky',
            __('Never Sticky', 'avia_framework') => 'never_sticky',
        ));


    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Main Menu Sidebar", 'avia_framework'),
        "desc" => __("You can choose to use the main menu area to also display widget areas", 'avia_framework'),
        "id" => "sidebarmenu_widgets",
        "type" => "select_sidebar",
        "std" => "",
        "no_first" => true,
        "required" => array('header_position', '{contains}header_sidebar'),
        "target" => array("default_layout_target::.avprev-layout-container-widget::set_active"),
        "exclude" => array(), /*eg: 'Displayed Everywhere'*/
        "additions" => array('No widgets' => "", /* 'Display Widgets by page logic' => "av-auto-widget-logic", */
            'Display a specific Widget Area' => '%result%'),
    );


    $avia_elements[] = array(
        "name" =>
            __("Display social icons below main menu? (You can set your social icons at", 'avia_framework') .
            " <a href='#goto_social'>" .
            __("Social Profiles", 'avia_framework') .
            "</a>)"
    ,
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "sidebarmenu_social",
        "type" => "checkbox",
        "std" => "",
        "slug" => "layout",
        "target" => array("default_layout_target::.avprev-layout-container-social::set_active"),
        "required" => array('header_position', '{contains}header_sidebar'),
    );


// END TAB
    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_end", "id" => "avia_tab5ewwe_end", "nodescription" => true);
    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_start", "id" => "avia_tab5wewe", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Dimensions', 'avia_framework'));
// START TAB


    $avia_elements[] = array(
        "name" => __("Responsive Site", 'avia_framework'),
        "desc" => __("If enabled the size of your website will adapt and change the layout to fit smaller screens, like tablets or mobile phones", 'avia_framework'),
        "id" => "responsive_active",
        "type" => "checkbox",
        "std" => "enabled",
        "slug" => "layout",
    );

    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Maximum Container width", 'avia_framework'),
        "desc" => __("Enter the maximum content width for your site. Pixel and % are allowed eg: 1130px, 1310px, 100% ", 'avia_framework'),
        "id" => "responsive_size",
        "type" => "text",
        "std" => "1310px",
        "required" => array('responsive_active', '{contains}enabled'),
    );


    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Content | Sidebar Ratio", 'avia_framework'),
        "desc" => __("Here you can choose the width of your content and sidebar. First Number indicates the content width, second number indicates sidebar width.", 'avia_framework') . "<br/><strong>" . __("Note:", 'avia_framework') . "</strong> " .
            __("If you want to disable sidebars you can do so in the", 'avia_framework') .
            " <a href='#goto_sidebars'>" .
            __("Sidebar Settings", 'avia_framework') .
            "</a>",
        "id" => "content_width",
        "target" => array("default_layout_target::.avprev-layout-content::width"),
        "type" => "select",
        "std" => "73",
        "no_first" => true,
        "subtype" => array(
            '80% | 20%' => '80',
            '79% | 21%' => '79',
            '78% | 22%' => '78',
            '77% | 23%' => '77',
            '76% | 24%' => '76',
            '75% | 25%' => '75',
            '74% | 26%' => '74',
            '73% | 27%' => '73',
            '72% | 28%' => '72',
            '71% | 29%' => '71',

            '70% | 30%' => '70',
            '69% | 31%' => '69',
            '68% | 32%' => '68',
            '67% | 33%' => '67',
            '66% | 34%' => '66',
            '65% | 35%' => '65',
            '64% | 36%' => '64',
            '63% | 37%' => '63',
            '62% | 38%' => '62',
            '61% | 39%' => '61',

            '60% | 40%' => '60',
            '59% | 41%' => '59',
            '58% | 42%' => '58',
            '57% | 43%' => '57',
            '56% | 44%' => '56',
            '55% | 45%' => '55',
            '54% | 46%' => '54',
            '53% | 47%' => '53',
            '52% | 48%' => '52',
            '51% | 49%' => '51',
            '50% | 50%' => '50',

        ));

    $numbers = array();
    for ($i = 100; $i >= 50; $i--) {
        $numbers[$i . "%"] = $i;
    }

    $avia_elements[] = array(
        "slug" => "layout",
        "name" => __("Content + Sidebar width", 'avia_framework'),
        "desc" => __("Here you can enter the combined width of content and sidebar", 'avia_framework'),
        "id" => "combined_width",
        "target" => array("default_layout_target::.avprev-layout-container-sizer::width"),
        "type" => "select",
        "std" => "100",
        "no_first" => true,
        "subtype" => $numbers
    );


// END TAB
    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_end", "id" => "avia_tab4543_end", "nodescription" => true);


//END TAB CONTAINER
    $avia_elements[] = array("slug" => "layout", "type" => "visual_group_end", "id" => "avia_tab_container_end2", "nodescription" => true);


    $warning = '<br />';
    $warning .= '<strong>';
    $warning .= __('We strongly recommend to export your current settings now to have a fallback.', 'avia_framework');
    $warning .= '</strong>';


    if (is_child_theme()) {
        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Import Settings From Your Parent Theme', 'avia_framework'),
            'desc' => __("We have detected that you are using a Child Theme. That's Great!. If you want to, we can import the settings of your Parent theme to your Child theme. Please be aware that this will overwrite your current child theme settings.", 'avia_framework') . $warning,
            'id' => 'parent_setting_import',
            'type' => 'parent_setting_import'
        );
    }


    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Export Theme Settings File', 'avia_framework'),
        'desc' => __('Click the button to generate and download a config file which contains the theme settings. You can use the config file to import the theme settings on another sever.', 'avia_framework'),
        'id' => 'theme_settings_export',
        'type' => 'theme_settings_export'
    );


    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Select Theme Options To Import', 'avia_framework'),
        'desc' => __('Check if you do not want to import all settings from an exported theme settings file. Please read the <a href="https://kriesi.at/documentation/enfold/backup-theme-settings" target="_blank" rel="noopener noreferrer">documentation</a> for more information how to customize import.', 'avia_framework'),
        'id' => 'upload_filter_checkbox',
        'type' => 'checkbox',
        'std' => ''
    );

    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Keep Quick CSS Content', 'avia_framework'),
        'desc' => __('Check if you want to keep your added CSS stylings in &quot;General Styling -> Quick CSS&quot;. In case you select single tabs to import below your Quick CSS settings will be kept by default except you select the tab containing the Quick CSS field. In this case you must check here to keep them.', 'avia_framework'),
        'id' => 'upload_keep_quick_css',
        'type' => 'checkbox',
        'std' => '',
        'required' => array('upload_filter_checkbox', 'upload_filter_checkbox'),
    );

    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Select Theme Options Tabs For Import', 'avia_framework'),
        'desc' => __('Do not select any tabs to import all or select which tabs of the theme options you want to import from the uploaded settings file. All options in these selected tabs will be imported - options in other tabs will not be modified.', 'avia_framework'),
        'id' => 'upload_filter_tabs',
        'type' => 'select',
        'multiple' => '6',
        'required' => array('upload_filter_checkbox', 'upload_filter_checkbox'),
        'std' => '',
        'no_first' => true,
        'subtype' => 'option_page_tabs'
    );

    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Import Theme Settings File', 'avia_framework'),
        'desc' => __("Upload a theme configuration file here. Note that the configuration file settings will overwrite your current configuration and you can't restore the current configuration afterwards.", 'avia_framework') . $warning,
        'id' => 'config_file_upload',
        'title' => __('Upload Theme Settings File', 'avia_framework'),
        'button' => __('Insert Settings File', 'avia_framework'),
        'trigger' => 'av_config_file_insert',
        // 'fopen_check' 	=> 'true',
        'std' => '',
        'file_extension' => 'txt',
        'file_type' => 'text/plain',
        'type' => 'file_upload'
    );

    if (!current_theme_supports('avia_disable_reset_options')) {
        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Theme Reset All Options Button', 'avia_framework'),
            'desc' => __('Select if you want to block reset of theme options and hide the reset button. You must select activate button before you can reset theme options.', 'avia_framework'),
            'id' => 'reset_options_button',
            'type' => 'select',
            'std' => '',
            'no_first' => true,
            'subtype' => array(
                __('Activate reset all options button', 'avia_framework') => '',
                __('Block and hide reset all options button', 'avia_framework') => 'block_hide',
            )
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'type' => 'visual_group_start',
            'id' => 'avia_reset_button_group_start',
            'nodescription' => true,
            'required' => array('reset_options_button', ''),
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Select Theme Options To Reset', 'avia_framework'),
            'desc' => __('Check if you do not want to reset all options. Please read the <a href="https://kriesi.at/documentation/enfold/backup-theme-settings" target="_blank" rel="noopener noreferrer">documentation</a> for more information how to customize resetting theme options.', 'avia_framework'),
            'id' => 'reset_filter_checkbox',
            'type' => 'checkbox',
            'std' => ''
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Keep Quick CSS Content', 'avia_framework'),
            'desc' => __('Check if you want to keep your added CSS stylings in &quot;General Styling -> Quick CSS&quot;. In case you select single tabs to reset below your Quick CSS settings will be kept by default except you select the tab containing the Quick CSS field. In this case you must check here to keep them.', 'avia_framework'),
            'id' => 'reset_keep_quick_css',
            'type' => 'checkbox',
            'std' => '',
            'required' => array('reset_filter_checkbox', 'reset_filter_checkbox'),
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Select Theme Options Tabs To Reset', 'avia_framework'),
            'desc' => __('Do not select any tabs to reset all options or select which tabs of the theme options you want to reset. All options in these selected tabs will be set to theme factory values - options in other tabs will not be modified.', 'avia_framework'),
            'id' => 'reset_filter_tabs',
            'type' => 'select',
            'multiple' => '6',
            'required' => array('reset_filter_checkbox', 'reset_filter_checkbox'),
            'std' => '',
            'no_first' => true,
            'subtype' => 'option_page_tabs'
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'name' => __('Reset Selected Options', 'avia_framework'),
            'desc' => __('Click the button to reset selected options to theme factory default values. Note that this will overwrite your current configuration and you cannot restore the current configuration afterwards.', 'avia_framework') . $warning,
            'id' => 'reset_selected_button',
            'type' => 'reset_selected_button',
            'required' => array('reset_filter_checkbox', 'reset_filter_checkbox'),
        );

        $avia_elements[] = array(
            'slug' => 'upload',
            'type' => 'visual_group_end',
            'id' => 'avia_reset_button_group_end',
            'nodescription' => true
        );

    }

    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Export Layout Builder Templates', 'avia_framework'),
        'desc' => __('Click the button to generate and download a file which contains the Layout Builder saved templates. You can use this file to import the templates on another server.', 'avia_framework'),
        'id' => 'alb_templates_export',
        'type' => 'alb_templates_export'
    );

    $avia_elements[] = array(
        'slug' => 'upload',
        'name' => __('Import Layout Builder Templates File', 'avia_framework'),
        'desc' => __("Upload a Layout Builder Templates file here. The uploaded templates will be added to the existing templates. Same named templates will not be overwritten.", 'avia_framework'),
        'id' => 'alb_templates_upload',
        'title' => __('Upload Layout Builder Templates File', 'avia_framework'),
        'button' => __('Insert Layout Builder Templates File', 'avia_framework'),
        'trigger' => 'av_alb_templates_file_insert',
        // 'fopen_check' 	=> 'true',
        'std' => '',
        'file_extension' => 'txt',
        'file_type' => 'text/plain',
        'type' => 'file_upload'
    );

    $avia_elements[] = array(
        "slug" => "upload",
        "name" => __("Iconfont Manager", 'avia_framework'),
        "desc" => __("You can upload additional Iconfont Packages generated with", 'avia_framework') . " <a href='http://fontello.com/' target='_blank' rel='noopener noreferrer'>Fontello</a>  " .
            __("or use monocolored icon sets from", 'avia_framework') . " <a href='http://www.flaticon.com/' target='_blank' rel='noopener noreferrer'>Flaticon</a>. " .
            __("Those icons can then be used in your Layout Builder.", 'avia_framework') . "<br/><br/>" .
            __("The 'Default Font' can't be deleted.", 'avia_framework') . "<br/><br/>" .
            __("Make sure to delete any fonts that you are not using, to keep the loading time for your visitors low", 'avia_framework'),
        "id" => "iconfont_upload",
        "title" => __("Upload/Select Fontello Font Zip", 'avia_framework'),
        "button" => __("Insert Zip File", 'avia_framework'),
        "trigger" => "av_fontello_zip_insert",
        // "fopen_check" 	=> "true",
        "std" => "",
        "type" => "file_upload",
        "file_extension" => "zip", //used to check if user can upload this file type
        "file_type" => "application/octet-stream, application/zip", //used for javascript gallery to display file types
    );


    $avia_elements[] = array(
        "slug" => "upload",
        "name" => __("Custom Font Manager", 'avia_framework'),
        "desc" => __("You can upload your custom Font zip files. Intended for <a href='https://fonts.google.com/' target='_blank' rel='noopener noreferrer'>Google Webkit Fonts</a>.", 'avia_framework') .
            "<br/><br/>" .
            __("Make sure to delete any fonts that you are not using, to keep the loading time for your visitors low", 'avia_framework'),
        "id" => "typefont_upload",
        "title" => __("Upload/Select Font Zip File", 'avia_framework'),
        "button" => __("Insert Zip File", 'avia_framework'),
        "trigger" => "av_typefont_zip_insert",
        // "fopen_check" 	=> "true",
        "std" => "",
        "type" => "file_upload",
        "file_extension" => "zip", //used to check if user can upload this file type
        "file_type" => "application/octet-stream, application/zip", //used for javascript gallery to display file types
    );


    /*Frontpage Settings*/

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('Frontpage Settings', 'avia_framework'),
        'desc' => __('Select which page to display on your Frontpage. If left blank the Blog will be displayed. In case you do not see a select box - you have to publish pages.', 'avia_framework'),
        'id' => 'frontpage',
        'type' => 'select',
        'subtype' => 'page'
    );

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('And where do you want to display the Blog?', 'avia_framework'),
        'desc' => __('Select which page to display as your Blog Page. If left blank no blog will be displayed. In case you do not see a select box - you have to publish pages.', 'avia_framework'),
        'id' => 'blogpage',
        'type' => 'select',
        'subtype' => 'page',
        'required' => array('frontpage', '{true}')
    );

    $avia_elements[] = array(
        'desc' => "<strong class='av-text-notice av-prev-el-notice'>" . __('Notice: Your blog is currently disabled. You can enable it', 'avia_framework') . ' <a target="_blank" href="' . admin_url('admin.php?page=avia#goto_performance') . '">' . __('here', 'avia_framework') . '</a></strong>',
        'id' => 'widgetdescription',
        'std' => '',
        'slug' => 'avia',
        'type' => 'heading',
        'required' => array('disable_blog', '{true}'),
        'nodescription' => true
    );

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('Logo', 'avia_framework'),
        "desc" => __("Upload a logo image, or enter the URL or ID of an image if its already uploaded. The themes default logo gets applied if the input field is left blank", 'avia_framework') . "<br/><br/>" . __("Logo Dimension: 340px * 156px (if your logo is larger you might need to change the Header size in your", 'avia_framework') .
            " <a href='#goto_header'>" .
            __("Header Settings", 'avia_framework') .
            "</a>",
        "id" => "logo",
        "type" => "upload",
        "label" => __("Use Image as logo", 'avia_framework'));

    $avia_elements[] = array(
        "slug" => "avia",
        "name" => __("Favicon", 'avia_framework'),
        "desc" => __("Specify a favicon for your site.", 'avia_framework') . " <br/>" . __("Accepted formats: .ico, .png, .gif", 'avia_framework') . " <br/><br/>" .
            __("What is a", 'avia_framework') .
            " <a target='_blank' href='http://en.wikipedia.org/wiki/Favicon' rel='noopener noreferrer'>" .
            __("favicon", 'avia_framework') .
            "?</a>",
        "id" => "favicon",
        "type" => "upload",
        "label" => __("Use Image as Favicon", 'avia_framework'));


    $avia_elements[] = array("slug" => "avia", "type" => "visual_group_start", "id" => "avia_preload", "nodescription" => true);

    $avia_elements[] = array(
        "slug" => "avia",
        "name" => __("Page Preloading", 'avia_framework'),
        "desc" => __("Show a preloader when opening a page on your site.", 'avia_framework'),
        "id" => "preloader",
        "type" => "checkbox",
        "std" => false,
    );

    $avia_elements[] = array(
        "slug" => "avia",
        "name" => __("Page Transitions", 'avia_framework'),
        "desc" => __("Smooth page transition when navigating from one page to the next. Please disable if this causes problems with plugins when navigating ajax or otherwise dynamical created content", 'avia_framework'),
        "id" => "preloader_transitions",
        "type" => "checkbox",
        "std" => 'preloader_transitions',
        "required" => array("preloader", 'preloader'),
    );

    $avia_elements[] = array(
        "slug" => "avia",
        "name" => __("Custom Logo for preloader", 'avia_framework'),
        "desc" => __("Upload an optional logo image for your preloader page", 'avia_framework'),
        "id" => "preloader_logo",
        "type" => "upload",
        "required" => array("preloader", 'preloader'),
        "label" => __("Use Image as logo", 'avia_framework'));

    $avia_elements[] = array("slug" => "avia", "type" => "visual_group_end", "id" => "avia_preload_end", "nodescription" => true);


    $avia_elements[] = array("slug" => "avia", "type" => "visual_group_start", "id" => "avia_lightbox", "nodescription" => true);


    $avia_elements[] = array(
        "name" => __("Lightbox Modal Window", 'avia_framework'),
        "desc" => __("Check to enable the default lightbox that opens once you click a link to an image. Uncheck only if you want to use your own modal window plugin", 'avia_framework'),
        "id" => "lightbox_active",
        "type" => "checkbox",
        "std" => "true",
        "slug" => "avia");

    $avia_elements[] = array("slug" => "avia", "type" => "visual_group_end", "id" => "avia_lightbox_end", "nodescription" => true);


    /**
     * Error 404 page section
     *
     * @author tinabillinger
     * @since 4.3
     */
    $avia_elements[] = array('slug' => 'avia', 'type' => 'visual_group_start', 'id' => 'avia_404_start', 'nodescription' => true);

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('Custom Error 404 Page', 'avia_framework'),
        'desc' => __('Select if you want to use any of your pages as your custom Error 404 Page. This page will be excluded from page lists and search results. You must deselect the page to make it accessible for public again.', 'avia_framework'),
        'id' => 'error404_custom',
        'type' => 'select',
        'no_first' => true,
        'std' => '',
        'subtype' => array(
            __('No custom 404 page selected', 'avia_framework') => '',
            __('Display selected page without redirect', 'avia_framework') => 'error404_custom',
            __('Redirect to selected page', 'avia_framework') => 'error404_redirect'
        )
    );

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('Select Your Custom Error 404 Page', 'avia_framework'),
        'desc' => __('If you are using a caching plugin, make sure to exclude this page from caching.', 'avia_framework'),
        'required' => array('error404_custom', '{contains_array}error404_custom;error404_redirect'),
        'id' => 'error404_page',
        'type' => 'select',
        'subtype' => 'page'
    );

    $avia_elements[] = array('slug' => 'avia', 'type' => 'visual_group_end', 'id' => 'avia_404_end', 'nodescription' => true);


    /**
     * Maintenance mode section
     *
     * @author tinabillinger
     * @since 4.3
     */

    $avia_elements[] = array('slug' => 'avia', 'type' => 'visual_group_start', 'id' => 'avia_maintain_start', 'nodescription' => true);

    $avia_elements[] = array(
        'name' => __('Maintenance Mode', 'avia_framework'),
        'slug' => 'avia',
        'desc' => __('Check to enable maintenance mode and show or redirect all page requests to a maintenance page of your choice. This page will not be accessable and will be excluded from page lists and search results. You must deselect the page to make it accessible for public again.', 'avia_framework'),
        'id' => 'maintenance_mode',
        'type' => 'select',
        'no_first' => true,
        'std' => '',
        'subtype' => array(
            __('Disabled', 'avia_framework') => '',
            __('Enabled - Use selected page content without redirect', 'avia_framework') => 'maintenance_mode',
            __('Enabled - Redirect to selected page', 'avia_framework') => 'maintenance_mode_redirect'
        )
    );

    $avia_elements[] = array(
        'slug' => 'avia',
        'name' => __('Select Your Maintenance Mode Page', 'avia_framework'),
        'desc' => __('Please note that logged in Administrators, Editors and Authors will still be able to access the site', 'avia_framework'),
        'required' => array('maintenance_mode', '{contains_array}maintenance_mode;maintenance_mode_redirect'),
        'id' => 'maintenance_page',
        'type' => 'select',
        'subtype' => 'page'
    );

    $avia_elements[] = array('slug' => 'avia', 'type' => 'visual_group_end', 'id' => 'avia_maintain_end', 'nodescription' => true);


    /**
     * Disable block editor section - since WP 5.0
     *
     * @author Guenter
     * @since 4.5.2
     */
    global $wp_version;

    if (version_compare($wp_version, '5.0', '>=')) {
        $avia_elements[] = array(
            'slug' => 'avia',
            'type' => 'visual_group_start',
            'id' => 'avia_block_editor_start',
            'nodescription' => true
        );

        $avia_elements[] = array(
            'name' => __('Select Your Editor', 'avia_framework'),
            'slug' => 'avia',
            'desc' => __('Choose if you want to enable and use the built in classic editor - no plugin is needed.', 'avia_framework'),
            'id' => 'enable_wp_classic_editor',
            'type' => 'select',
            'std' => '',
            'no_first' => true,
            'subtype' => array(
                __('Use Block Editor', 'avia_framework') => '',
                __('Use WP Classic Editor', 'avia_framework') => 'enable_wp_classic_editor'
            )
        );

        /**
         * As a first step we ignore the option by default - as a beta user may activate it
         * @since 4.5.2
         */
        if (current_theme_supports('avia_gutenberg_post_type_support')) {
            $avia_elements[] = array(
                'slug' => 'avia',
                'name' => __('Disable Block Editor For Selected Post Types:', 'avia_framework'),
                'desc' => __('Only the classic WP editor will be used for the selected post types. The links to WP block editor (Gutenberg) will not be available. You can change this behaviour for certain pages/posts with Enfold&rsquo;s filter &quot;avf_use_block_editor_for_post&quot;', 'avia_framework'),
                'required' => array('enable_wp_classic_editor', 'enable_wp_classic_editor'),
                'id' => 'disable_block_editor_post_type',
                'type' => 'select',
                'subtype' => 'post_type',
                'features' => array('editor'),
                'multiple' => true,
                'option_none_text' => __('Allow block editor for all possible post types (= default)...', 'avia_framework'),
                'option_all_text' => __('Disable block editor for all listed post types...', 'avia_framework')
            );
        }

        $avia_elements[] = array(
            'slug' => 'avia',
            'type' => 'visual_group_end',
            'id' => 'avia_block_editor_end',
            'nodescription' => true
        );
    }

    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Select a predefined color scheme", 'avia_framework'),
        "desc" => __("Choose a predefined color scheme here. You can edit the settings of the scheme below then.", 'avia_framework'),
        "id" => "color_scheme",
        "type" => "link_controller",
        "std" => "Blue",
        "class" => "link_controller_list",
        "subtype" => $styles);


    $avia_elements[] = array(
        "slug" => "customizer",
        "name" => __("Here you can select a number of different elements and change their default styling", 'avia_framework'),
        "desc" => __("If a value is left empty or set to default then it will not be changed from the value defined in your CSS files", 'avia_framework') . "<br/><br/><strong>" .
            __("Attention", 'avia_framework') . ": </strong>" .
            __("This feature is in active BETA! We will constantly add new elements to customize and need your help: If you got any suggestions on what to add please post them here:", 'avia_framework') .
            " <a target='_blank' href='https://kriesi.at/support/enfold-feature-requests/' rel='noopener noreferrer'>" .
            __("Enfold Feature Requests", 'avia_framework') .
            "</a><br/><br/>"
    ,
        "id" => "advanced_styling",
        "type" => "styling_wizard",
        "order" => array(
            __("HTML Tags", 'avia_framework'),
            __("Headings", 'avia_framework'),
            __("Main Menu", 'avia_framework'),
            __("Main Menu (Icon)", 'avia_framework'),
            __("Cookie Consent Bar", 'avia_framework'),
            __("Misc", 'avia_framework')
        ),
        "std" => "",
        "class" => "",
        "elements" => $advanced);


    /*Styling Settings*/
    $avia_elements[] = array(
        "slug" => "styling",
        "id" => "default_slideshow_target",
        "type" => "target",
        "std" => "
					<style type='text/css'>

						#boxed .live_bg_wrap{ padding:0 23px;   border:1px solid #e1e1e1; background-position: top center;}
						#av-framed-box .live_bg_wrap{ padding:23px;   border:1px solid #e1e1e1; background-position: top center;}
						.live_bg_small{font-size:10px; color:#999;     height: 23px; display: block;}
						.live_bg_wrap{ padding: 0; background:#f8f8f8; overflow:hidden; background-position: top center;}
						.live_bg_wrap div{overflow:hidden; position:relative;}
						#avia_options_page .live_bg_wrap h3{margin: 0 0 5px 0 ; color:inherit; font-size:25px;}
						#avia_options_page .live_bg_wrap .main_h3{font-weight:bold; font-size:25px;  }
						.border{border:1px solid; border-bottom-style:none; border-bottom-width:0; padding:13px; width:100%;}
						#av-framed-box .border{}

						.live_header_color {position: relative;width: 100%;right: }
						.bg2{border:1px solid; margin:4px; display:block; float:left; padding:15px; }
						.content_p{display:block; float:right; width: 100%;}
						.live-socket_color{font-size:11px;}
						.live-footer_color a{text-decoration:none;}
						.live-socket_color a{text-decoration:none;  position:absolute; top:28%; left:13px;}

						#avia_preview .webfont_google_webfont{  font-weight:normal; }
						.webfont_default_font{  font-weight:normal; font-size:13px; line-height:1.7em;}

						div .link_controller_list a{ width:113px; font-size:13px;}
						.avia_half{width: 50%; float:right; min-height:210px;}
						.avia_half .bg2{float:none; margin-right:0;}
						.avia_half_2{border-right:none; padding-right:14px;}
						#av-framed-box #header_left  .avia_half { width: 179px; height:250px;}
						.live-slideshow_color{text-align:center;}
						.text_small_outside{position:relative; top:-15px; display:block; right: 10px;}
						
						#header_left .live-header_color{ float:right;  width:30%; min-height: 424px; border-bottom:1px solid; border-left: none;}
						#header_right .live-header_color{float:left; width:30%; min-height: 424px; border-bottom:1px solid; border-right:  none;}
						#header_left .live-header_color .bg2, 
						#header_right .live-header_color .bg2,
						#header_right .av_header_block_1,
						#header_left .av_header_block_1{
							float:none;
							width:100%;
						}
						.av-sub-logo-area{overflow:hidden;}

						#boxed #header_left .live-header_color, #boxed #header_right .live-header_color{min-height: 424px; }
						#header_right .avia_half, #header_left .avia_half{min-height: 250px;}
						#boxed .live-socket_color{border-bottom:1px solid;}
						.av_header_block_1{width:70%; float:right;}
						.live-header_color .bg2{width:30%; margin: 15px 0 0 0;}
						#av-framed-box .live-socket_color.border{border-bottom-style:solid; border-bottom-width:1px;}
					</style>





					<small class='live_bg_small'>{$frontend_label}</small>

					<div id='avia_preview' class='live_bg_wrap webfont_default_font'>
					<div class='avprev-design-container'>
					<!--<small class='text_small_outside'>Next Event: in 10 hours 5 minutes.</small>-->


						<div class='live-header_color border'>
							<div class='av_header_block_1'>
								<h3 class='heading webfont_google_webfont'>عنوان ناحیه لوگو</h3>
								<span class='text'>آیتم فعال منو | </span>
								<span class='meta'>آیتم غیرفعال منو</span><br/>
								<a class='a_link' href='#'>لینک متنی دلخواه</a>
								<a class='an_activelink' href='#'>لینک هاوردار</a>
							</div>
							<div class='bg2'>پس زمینه هایلایت دار + حاشیه</div>
						</div>
						
						<div class='av-sub-logo-area'>

						

						<div class='live-main_color border avia_half'>
							<h3 class='webfont_google_webfont main_h3 heading'>عنوان محتوای اصلی</h3>
								<p class='content_p'>این محتوای پیش فرض با یک عنوان پیش فرض است. رنگ فونت، عناوین، و لینک ها می توانند در پایین انتخاب شوند. <br/>
									<a class='a_link' href='#'>یک لینک</a>
									<a class='an_activelink' href='#'>یک لینک هاور دار</a>
									<span class='meta'>فونت دوم</span>

								</p>

								<div class='bg2'>پس زمینه هایلایت دار + حاشیه</div>
						</div>



						<div class='live-alternate_color border avia_half avia_half_2'>
								<h3 class='webfont_google_webfont main_h3 heading'>ناحیه محتوای جایگزین</h3>
								<p class='content_p'>این محتوای ناحیه محتوای جایگزین است. رنگ فونت، عناوین، و لینک ها می توانند در پایین انتخاب شوند. <br/>
									<a class='a_link' href='#'>یک لینک</a>
									<a class='an_activelink' href='#'>یک لینک هاور دار</a>
									<span class='meta'>فونت دوم</span>

								</p>

								<div class='bg2'>پس زمینه هایلایت دار + حاشیه</div>
						</div>

						<div class='live-footer_color border'>
							<h3 class='webfont_google_webfont heading'>عنوان پیش نمایش (پاورقی)</h3>
							<p>این متن پس زمینه پاورقی است.</p>
							<a class='a_link' href='#'>لینک 1 | لینک 2</a>
							<span class='meta'> | فونت دوم</span>

						</div>

						<div class='live-socket_color border'>متن سوکت <a class='a_link' href='#'>لینک 1 | لینک 2</a>
													<span class='meta'> | فونت دوم</span>

						</div>
					</div>
					</div>
					</div>

					",
        "nodescription" => true
    );


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_start", "id" => "avia_tab1", "nodescription" => true, 'class' => 'avia_tab_container avia_set');


//create color sets for #header, Main Content, Secondary Content, Footer, Socket, Slideshow

    $colorsets = $avia_config['color_sets'];
    $iterator = 1;

    foreach ($colorsets as $set_key => $set_value) {
        $iterator++;

        $avia_elements[] = array("slug" => "styling", "type" => "visual_group_start", "id" => "avia_tab" . $iterator, "nodescription" => true, 'class' => 'avia_tab avia_tab' . $iterator, 'name' => $set_value);

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => $set_value . " " . __("background color", 'avia_framework'),
            "id" => "colorset-$set_key-bg",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_1",
            "std" => "#ffffff",
            "desc" => __("Default Background color", 'avia_framework'),
            "target" => array("default_slideshow_target::.live-$set_key::background-color"),
        );

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Alternate Background color", 'avia_framework'),
            "desc" => __("Alternate Background for menu hover, tables etc", 'avia_framework'),
            "id" => "colorset-$set_key-bg2",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_2",
            "std" => "#f8f8f8",
            "target" => array("default_slideshow_target::.live-$set_key .bg2::background-color"),
        );

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Primary color", 'avia_framework'),
            "desc" => __("Font color for links, dropcaps and other elements", 'avia_framework'),
            "id" => "colorset-$set_key-primary",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_1",
            "std" => "#719430",
            "target" => array("default_slideshow_target::.live-$set_key .a_link, .live-$set_key-wrap-top::color,border-color"),
        );


        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Highlight color", 'avia_framework'),
            "desc" => __("Secondary color for link and button hover, etc", 'avia_framework') . "<br/>",
            "id" => "colorset-$set_key-secondary",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_2",
            "std" => "#8bba34",
            "target" => "default_slideshow_target::.live-$set_key .an_activelink::color",
        );


        $avia_elements[] = array(
            "slug" => "styling",
            "name" => $set_value . " " . __("font color", 'avia_framework'),
            "id" => "colorset-$set_key-color",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_1",
            "std" => "#000000",
            "target" => array("default_slideshow_target::.live-$set_key::color"),
        );

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => $set_value . " " . __("secondary font color", 'avia_framework'),
            "id" => "colorset-$set_key-meta",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_2",
            "std" => "#969696",
            "target" => array("default_slideshow_target::.live-$set_key .meta::color"),
        );

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => $set_value . " " . __("Heading color", 'avia_framework'),
            "id" => "colorset-$set_key-heading",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_1",
            "std" => "#000000",
            "target" => array("default_slideshow_target::.live-$set_key .heading::color"),
        );


        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Border colors", 'avia_framework'),
            "id" => "colorset-$set_key-border",
            "type" => "colorpicker",
            "class" => "av_2columns av_col_2",
            "std" => "#ebebeb",
            "target" => array("default_slideshow_target::.live-$set_key.border, .live-$set_key .bg2::border-color"),
        );


        $avia_elements[] = array("slug" => "styling", "type" => "hr", "id" => "hr" . $set_key, "nodescription" => true);

        $avia_elements[] = array(
            "slug" => "styling",
            "id" => "colorset-$set_key-img",
            "name" => __("Background Image", 'avia_framework'),
            "desc" => __("The background image of your", 'avia_framework') . " " . $set_value . "<br/>",
            "type" => "select",
            "subtype" => array(__('No Background Image', 'avia_framework') => '', __('Upload custom image', 'avia_framework') => 'custom'),
            "std" => "",
            "no_first" => true,
            "class" => "av_2columns av_col_1",
            "target" => array("default_slideshow_target::.live-$set_key::background-image"),
            "folder" => "images/background-images/",
            "folderlabel" => "",
            "group" => "Select predefined pattern",
        );


        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Custom Background Image", 'avia_framework'),
            "desc" => __("Upload a BG image for your", 'avia_framework') . " " . $set_value . "<br/>",
            "id" => "colorset-$set_key-customimage",
            "type" => "upload",
            "std" => "",
            "class" => "set_blank_on_hide av_2columns av_col_2",
            "label" => __("Use Image", 'avia_framework'),
            "required" => array("colorset-$set_key-img", 'custom'),
            "target" => array("default_slideshow_target::.live-$set_key::background-image"),
        );


        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Position of the image", 'avia_framework'),
            "desc" => "",
            "id" => "colorset-$set_key-pos",
            "type" => "select",
            "std" => "top left",
            "no_first" => true,
            "class" => "av_2columns av_col_1",
            "required" => array("colorset-$set_key-img", '{true}'),
            "target" => array("default_slideshow_target::.live-$set_key::background-position"),
            "subtype" => array(
                __('Top Left', 'avia_framework') => 'top left',
                __('Top Center', 'avia_framework') => 'top center',
                __('Top Right', 'avia_framework') => 'top right',
                __('Bottom Left', 'avia_framework') => 'bottom left',
                __('Bottom Center', 'avia_framework') => 'bottom center',
                __('Bottom Right', 'avia_framework') => 'bottom right',
                __('Center Left ', 'avia_framework') => 'center left',
                __('Center Center', 'avia_framework') => 'center center',
                __('Center Right', 'avia_framework') => 'center right'));

        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Repeat", 'avia_framework'),
            "desc" => "",
            "id" => "colorset-$set_key-repeat",
            "type" => "select",
            "std" => "no-repeat",
            "class" => "av_2columns av_col_2",
            "no_first" => true,
            "required" => array("colorset-$set_key-img", '{true}'),
            "target" => array("default_slideshow_target::.live-$set_key::background-repeat"),
            "subtype" => array(
                __('no repeat', 'avia_framework') => 'no-repeat',
                __('Repeat', 'avia_framework') => 'repeat',
                __('Tile Horizontally', 'avia_framework') => 'repeat-x',
                __('Tile Vertically', 'avia_framework') => 'repeat-y',
                /* 										    __('Stretch Fullscreen', 'avia_framework')=>'fullscreen' */
            ));
        $avia_elements[] = array(
            "slug" => "styling",
            "name" => __("Attachment", 'avia_framework'),
            "desc" => "",
            "id" => "colorset-$set_key-attach",
            "type" => "select",
            "std" => "scroll",
            "class" => "av_2columns av_col_1",
            "no_first" => true,
            "required" => array("colorset-$set_key-img", '{true}'),
            "target" => array("default_slideshow_target::.live-$set_key::background-attachment"),
            "subtype" => array(__('Scroll', 'avia_framework') => 'scroll', __('Fixed', 'avia_framework') => 'fixed'));


        $avia_elements[] = array("slug" => "styling", "type" => "visual_group_end", "id" => "avia_tab_end" . $iterator, "nodescription" => true);
    }


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_start", "id" => "avia_tab54", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Body background', 'avia_framework'),
        "required" => array("color-body_style", '{contains}box'),
        "inactive" => __("These options are only available if you select the 'boxed' or 'framed' layout. Your currently have a different layout selected", 'avia_framework') . "<br/><br/>" .
            __("You can change that setting", 'avia_framework') .
            " <a href='#goto_layout'>" .
            __("at General Layout", 'avia_framework') .
            "</a>");

    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Body Background color", 'avia_framework'),
        "desc" => __("Background color for your site", 'avia_framework') .
            "<br/>" .
            __("This is the color that is displayed behind your boxed content area", 'avia_framework'),
        "id" => "color-body_color",
        "type" => "colorpicker",
        "std" => "#eeeeee",
        /* 					"class" => "av_2columns av_col_2", */
        "target" => array("default_slideshow_target::.live_bg_wrap::background-color"),
    );


    $avia_elements[] = array(
        "slug" => "styling",
        "id" => "color-body_img",
        "name" => __("Background Image", 'avia_framework'),
        "desc" => __("The background image of your Body", 'avia_framework') . "<br/><br/>",
        "type" => "select",
        "subtype" => array(__('No Background Image', 'avia_framework') => '', __('Upload custom image', 'avia_framework') => 'custom'),
        "std" => "",
        "no_first" => true,
        "class" => "av_2columns av_col_1 set_blank_on_hide",
        "target" => array("default_slideshow_target::.live_bg_wrap::background-image"),
        "folder" => "images/background-images/",
        "folderlabel" => "",
        "required" => array("color-body_style", 'boxed'),
        "group" => "Select predefined pattern",

    );


    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Custom Background Image", 'avia_framework'),
        "desc" => __("Upload a BG image for your Body", 'avia_framework') . "<br/><br/>",
        "id" => "color-body_customimage",
        "type" => "upload",
        "std" => "",
        "class" => "set_blank_on_hide av_2columns av_col_2",
        "label" => __("Use Image", 'avia_framework'),
        "required" => array("color-body_img", 'custom'),
        "target" => array("default_slideshow_target::.live_bg_wrap::background-image"),
    );


    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Position of the image", 'avia_framework'),
        "desc" => "",
        "id" => "color-body_pos",
        "type" => "select",
        "std" => "top left",
        "no_first" => true,
        "class" => "av_2columns av_col_1",
        "required" => array("color-body_img", '{true}'),
        "target" => array("default_slideshow_target::.live_bg_wrap::background-position"),
        "subtype" => array(
            __('Top Left', 'avia_framework') => 'top left',
            __('Top Center', 'avia_framework') => 'top center',
            __('Top Right', 'avia_framework') => 'top right',
            __('Bottom Left', 'avia_framework') => 'bottom left',
            __('Bottom Center', 'avia_framework') => 'bottom center',
            __('Bottom Right', 'avia_framework') => 'bottom right',
            __('Center Left ', 'avia_framework') => 'center left',
            __('Center Center', 'avia_framework') => 'center center',
            __('Center Right', 'avia_framework') => 'center right'));

    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Repeat", 'avia_framework'),
        "desc" => "",
        "id" => "color-body_repeat",
        "type" => "select",
        "std" => "no-repeat",
        "class" => "av_2columns av_col_2",
        "no_first" => true,
        "required" => array("color-body_img", '{true}'),
        "target" => array("default_slideshow_target::.live_bg_wrap::background-repeat"),
        "subtype" => array(
            __('no repeat', 'avia_framework') => 'no-repeat',
            __('Repeat', 'avia_framework') => 'repeat',
            __('Tile Horizontally', 'avia_framework') => 'repeat-x',
            __('Tile Vertically', 'avia_framework') => 'repeat-y',
            __('Stretch Fullscreen', 'avia_framework') => 'fullscreen'));

    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Attachment", 'avia_framework'),
        "desc" => "",
        "id" => "color-body_attach",
        "type" => "select",
        "std" => "scroll",
        "class" => "av_2columns av_col_1",
        "no_first" => true,
        "required" => array("color-body_img", '{true}'),
        "target" => array("default_slideshow_target::.live_bg_wrap::background-attachment"),
        "subtype" => array(__('Scroll', 'avia_framework') => 'scroll', __('Fixed', 'avia_framework') => 'fixed'));


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_start", "id" => "avia_tab6", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Fonts', 'avia_framework'));


    $avia_elements[] = array("name" => __("Heading Font", 'avia_framework'),
        "slug" => "styling",
        "desc" => __("The Font heading allows you to use a wide range of fonts for your headings. Upload your own fonts, use websave fonts (faster rendering, but not mandatory installed on all devices) or Google webkit fonts (more unique).", 'avia_framework'),
        "id" => "google_webfont",
        "type" => "select",
        "no_first" => true,
        "class" => "av_2columns av_col_1",
        "onchange" => "avia_add_google_font",
        "std" => "Open Sans",
        "subtype" => apply_filters('avf_heading_font_select_options_list', AviaSuperobject()->type_fonts()->get_font_select_options_list())
    );

    $avia_elements[] = array("name" => __("Font for your body text", 'avia_framework'),
        "slug" => "styling",
        "desc" => __("Choose between your own uploaded fonts, web safe fonts (faster rendering, but not mandatory installed on all devices) and Google webkit fonts (more unique).", 'avia_framework') . "<br/>",
        "id" => "default_font",
        "type" => "select",
        "no_first" => true,
        "class" => "av_2columns av_col_2",
        "onchange" => "avia_add_google_font",
        "std" => "Helvetica-Neue,Helvetica-websave",
        "subtype" => apply_filters('avf_content_font_select_options_list', AviaSuperobject()->type_fonts()->get_font_select_options_list())
    );


    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Default content font size", 'avia_framework'),
        "desc" => __("The default font size for your content (eg: blog post content)", 'avia_framework'),
        "id" => "color-default_font_size",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "subtype" => array(
            __('Theme Default (13px)', 'avia_framework') => '',
            '11px' => '11px',
            '12px' => '12px',
            '13px' => '13px',
            '14px' => '14px',
            '15px' => '15px',
            '16px' => '16px',
            '17px' => '17px',
            '18px' => '18px',
            '19px' => '19px',
            '20px' => '20px',
            '21px' => '21px',
            '22px' => '22px',
            '23px' => '23px',
            '24px' => '24px',
            '25px' => '25px',
        ));


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_end", "id" => "avia_tabwe6_end", "nodescription" => true);


    $avia_elements[] = array("slug" => "styling", "type" => "visual_group_end", "id" => "avia_tab_container_end", "nodescription" => true);


    $avia_elements[] = array(
        "slug" => "styling",
        "name" => __("Quick CSS", 'avia_framework'),
        "desc" => __("Just want to do some quick CSS changes? Enter them here, they will be applied to the theme. If you need to change major portions of the theme please use the custom.css file", 'avia_framework') .
            " <a target='_blank' href='https://kriesi.at/documentation/enfold/using-a-child-theme/' rel='noopener noreferrer'>" .
            __("or the Enfold Child theme.", "avia_framework") .
            "</a>"
    ,
        "id" => "quick_css",
        "type" => "textarea"
    );


    $avia_elements[] = array(
        'slug' => 'styling',
        'name' => __('Show Custom Styles In Backend Block Editor', 'avia_framework'),
        'desc' => __('Select if you want to see theme custom styles when editing a page/post with the block editor.', 'avia_framework'),
        'id' => 'block_editor_theme_support',
        'type' => 'select',
        'required' => array('enable_wp_classic_editor', ''),
        'std' => '',
        'no_first' => true,
        'subtype' => array(
            __('Show Theme Custom Styles', 'avia_framework') => '',
            __('Use Block Editor Default Styles', 'avia_framework') => 'no_theme_support',
        )
    );

    /*Sidebar*/


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar on Archive Pages", 'avia_framework'),
        "desc" => __("Choose the archive sidebar position here. This setting will be applied to all archive pages", 'avia_framework'),
        "id" => "archive_layout",
        "type" => "select",
        "std" => "sidebar_right",
        "no_first" => true,
        "subtype" => array(__('left sidebar', 'avia_framework') => 'sidebar_left',
            __('right sidebar', 'avia_framework') => 'sidebar_right',
            __('no sidebar', 'avia_framework') => 'fullsize'
        ));


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar on Blog Page", 'avia_framework'),
        "desc" => __("Choose the blog sidebar position here. This setting will be applied to the blog page", 'avia_framework'),
        "id" => "blog_layout",
        "type" => "select",
        "std" => "sidebar_right",
        "no_first" => true,
        "subtype" => array(__('left sidebar', 'avia_framework') => 'sidebar_left',
            __('right sidebar', 'avia_framework') => 'sidebar_right',
            __('no sidebar', 'avia_framework') => 'fullsize'
        ));


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar on Single Post Entries", 'avia_framework'),
        "desc" => __("Choose the blog post sidebar position here. This setting will be applied to single blog posts", 'avia_framework'),
        "id" => "single_layout",
        "type" => "select",
        "std" => "sidebar_right",
        "no_first" => true,
        "subtype" => array(__('left sidebar', 'avia_framework') => 'sidebar_left',
            __('right sidebar', 'avia_framework') => 'sidebar_right',
            __('no sidebar', 'avia_framework') => 'fullsize'
        ));


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar on Pages", 'avia_framework'),
        "desc" => __("Choose the default page layout here. You can change the setting of each individual page when editing that page", 'avia_framework'),
        "id" => "page_layout",
        "type" => "select",
        "std" => "sidebar_right",
        "no_first" => true,
        "subtype" => array(__('left sidebar', 'avia_framework') => 'sidebar_left',
            __('right sidebar', 'avia_framework') => 'sidebar_right',
            __('no sidebar', 'avia_framework') => 'fullsize'
        ));

    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Separate Sidebars for Blog and Archive Pages", 'avia_framework'),
        "desc" => __("Show separate 'Archive Sidebar' on Archive Pages", 'avia_framework'),
        "id" => "archive_sidebar",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "subtype" => array(__('Show Blog Sidebar on Archive Pages', 'avia_framework') => '',
            __('Show separate Archive Sidebar on Archive Pages', 'avia_framework') => 'archive_sidebar_separate'
        ));


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar on Smartphones", 'avia_framework'),
        "desc" => __("Show sidebar on smartphones (Sidebar is displayed then below the actual content)", 'avia_framework'),
        "id" => "smartphones_sidebar",
        "type" => "checkbox",
        "std" => "",
        "no_first" => true,
        "subtype" => array(__('Hide sidebar on smartphones', 'avia_framework') => '',
            __('Show sidebar on smartphones', 'avia_framework') => 'smartphones_sidebar_visible'
        ));


    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Page Sidebar navigation", 'avia_framework'),
        "desc" => __("Display a sidebar navigation for all nested subpages of a page automatically?", 'avia_framework'),
        "id" => "page_nesting_nav",
        "type" => "checkbox",
        "std" => "true",
        "no_first" => true,
        "subtype" => array(__('Display sidebar navigation', 'avia_framework') => 'true',
            __("Don't display Sidebar navigation", 'avia_framework') => ""
        ));
    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Sidebar Separator Styling", 'avia_framework'),
        "desc" => __("Do you want to separate the sidebar from your main content with a border?", 'avia_framework'),
        "id" => "sidebar_styling",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "subtype" => array(
            __('With Border', 'avia_framework') => '',
            __('No Border', 'avia_framework') => 'no_sidebar_border',
            __('Shadow', 'avia_framework') => 'sidebar_shadow',
        ));

    $avia_elements[] = array(
        "slug" => "sidebars",
        "name" => __("Left Sidebar Text Alignment", 'avia_framework'),
        "desc" => __("Define text alignment for the left sidebar", 'avia_framework'),
        "id" => "sidebar_left_textalign",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "subtype" => array(
            __('Right', 'avia_framework') => '',
            __('Left', 'avia_framework') => 'align_left',
        ));


    $avia_elements[] = array("name" => __("Create new Sidebar Widget Areas", 'avia_framework'),
        "desc" => __("The theme supports the creation of custom widget areas. Simply open your", 'avia_framework') . " <a target='_blank' href='" . admin_url('widgets.php') . "'>" . __('Widgets Page', 'avia_framework') . "</a> " .
            __("and add a new Sidebar Area. Afterwards you can choose to display this Widget Area in the Edit Page Screen.", 'avia_framework'),
        "id" => "widgetdescription",
        "std" => "",
        "slug" => "sidebars",
        "type" => "heading",
        "nodescription" => true);


    /*Header Layout Settings*/


    $avia_elements[] = array("slug" => "header",
        "type" => "visual_group_start",
        "id" => "header_conditional",
        "nodescription" => true,
        "required" => array('header_position', '{contains}header_top'),
        "inactive" => __("These options are only available if you select a layout that has a main menu positioned at the top. You currently have your main menu placed in a sidebar", 'avia_framework') . "<br/><br/>" .
            __("You can change that setting", 'avia_framework') .
            " <a href='#goto_layout'>" .
            __("at General Layout", 'avia_framework') .
            "</a>");


    $frontendheader_label = __("A rough layout preview of the header area", 'avia_framework');

    $avia_elements[] = array(
        "slug" => "header",
        "id" => "default_header_target",
        "type" => "target",
        "std" => "
					<style type='text/css'>
					
					#avia_options_page #avia_default_header_target{background: #f8f8f8;border: none;padding: 30px;border-bottom: 1px solid #e5e5e5; margin-bottom: 25px;}
					#avia_header_preview{color:#999; border:1px solid #e1e1e1; padding:0px 45px; overflow:hidden; background-color:#fff; position: relative;}
					
					#avia_options_page #pr-main-area{line-height:69px; overflow:hidden;}
					#pr-menu{float:left; font-size:12px; line-height: inherit;}	
					
					#pr-menu .pr-menu-single{display:inline-block; padding:0px 7px; position:relative; }
					#pr-menu .main_nav_header .pr-menu-single{padding:20px 7px;}
					
					#pr-menu-inner.seperator_small_border .pr-menu-single{display:inline; border-left: 1px solid #e1e1e1; padding:0px 7px;}
					#pr-menu-inner.seperator_big_border .pr-menu-single{ border-left: 1px solid #e1e1e1; width: 80px; text-align: center; padding: 25px 7px;}
					#pr-menu-inner.seperator_big_border .pr-menu-single-first{border-right:1px solid #e1e1e1;}
					
					
					.bottom_nav_header #pr-menu-inner.seperator_big_border .pr-menu-single{padding: 9px 7px;}
					
					#pr-logo{ max-width: 150px; max-height: 70px; float:right;}
					#avia_header_preview.large #pr-logo{ max-width: 215px; max-height: 115px; padding-top:0px;}
					#avia_header_preview.large .main_nav_header #pr-menu-inner.seperator_big_border .pr-menu-single{padding: 48px 7px;}
					#avia_options_page #avia_header_preview.large #pr-main-area{line-height:15px;}
					
					#search_icon{opacity:0.3; margin-right: 10px; top:26px; position:relative; display:none; z-index:10; height:16px;}
					#search_icon.header_searchicon{display:inline; top:4px;}
					#pr-content-area{display:block; clear:both; padding:15px 45px; overflow:hidden; background-color:#fcfcfc; text-align:center; border:1px solid #e1e1e1; border-top:none;}
					.logo_right #pr-logo{float:left}
					.logo_center{text-align:center;}
					.logo_center #pr-logo{float:none}
					.menu_left #pr-menu{float:right}
					#avia_options_page .bottom_nav_header#pr-main-area{line-height: 1em;}
					.bottom_nav_header #pr-menu{float:none; clear:both; line-height:36px; }
					.top_nav_header div#pr-menu { position: absolute; top: -1px; width: 100%; right: 0; }
					.top_nav_header#pr-main-area{margin-top:40px;}
					.bottom_nav_header #pr-menu:before { content: ''; border-top: 1px solid #e1e1e1; width: 150%; position:absolute; height: 1px; right: -50px;}
					.top_nav_header #pr-menu:before{ top: 36px; }
					.minimal_header .top_nav_header #pr-menu:before{opacity:0;}
					.minimal_header_shadow .top_nav_header #pr-menu:before{opacity:1; box-shadow: 0 1px 3px 0px rgba(0,0,0,0.1); }
					
					
					#pr-menu-2nd{height: 28px; color:#aaa; border:1px solid #e1e1e1; padding:5px 45px; overflow:hidden; background-color:#f8f8f8; border-bottom:none; display:none; font-size:11px;}
					.extra_header_active #pr-menu-2nd{display:block;}
					.pr-secondary-items{display:none;}
					.secondary_left .pr-secondary-items, .secondary_right .pr-secondary-items{display:block; float:right; margin:0 0 0 10px;}
					.secondary_right .pr-secondary-items{float:left; margin:0 10px 0 0;}
					
					.pr-icons{opacity:0.3; display:none; position:relative; top:1px;}
					.icon_active_left.extra_header_active #pr-menu-2nd .pr-icons{display:block; float:right; margin:0 0 0 10px;}
					.icon_active_right.extra_header_active #pr-menu-2nd .pr-icons{display:block; float:left; margin:0 10px 0 0 ;}
					
					.icon_active_main #pr-main-icon{float:left; position:relative; line-height:inherit;}
					.icon_active_main #pr-main-icon .pr-icons{display:block; top: 3px; margin: 0 17px 0 0; line-height:inherit; width:66px;}					
					.icon_active_main .logo_right #pr-main-icon {right: 211px; float: right; width: 0px;}
					.icon_active_main .logo_right #pr-main-icon {right: 211px; float: right; width: 0px;}
					.icon_active_main .large .logo_right #pr-main-icon {right:-55px;}
					
					.icon_active_main .bottom_nav_header #pr-main-icon{top:23px;}
					.icon_active_main .large #pr-main-icon{top:46px;}
					
					.icon_active_main .logo_right.bottom_nav_header #pr-main-icon{float:right; right:-17px;}
					.icon_active_main .logo_center.bottom_nav_header #pr-main-icon{float: left; top: 0px; position: absolute; left: 24px;}
					.icon_active_main .large .logo_center.bottom_nav_header #pr-main-icon{top: 29px;}
					.icon_active_main .logo_center.bottom_nav_header #pr-main-icon .pr-icons{margin:0; top:35px;}
					.icon_active_main .large .logo_center.bottom_nav_header #pr-main-icon .pr-icons { top: 23px; }
										
					.pr-phone-items{display:none;}
					.phone_active_left  .pr-phone-items{display:block; float:right;}
					.phone_active_right .pr-phone-items{display:block; float:left;}
					
					.header_stretch #avia_header_preview, .header_stretch #pr-menu-2nd{ padding-right: 15px; padding-left: 15px; }
					.header_stretch .icon_active_main .logo_right.menu_left #pr-main-icon {right:-193px;}
					
					.inner-content{color:#999; text-align: justify; }
					
					#pr-breadcrumb{line-height:23px; color:#aaa; border:1px solid #e1e1e1; padding:5px 45px; overflow:hidden; background-color:#f8f8f8; border-top:none; font-size:16px;}
					#pr-breadcrumb .some-breadcrumb{float:left; font-size:11px; line-height:23px;}
					#pr-breadcrumb.title_bar .some-breadcrumb, #pr-breadcrumb.hidden_title_bar{ display:none; }
					
					.pr-menu-single.pr-menu-single-first:after {
					content: '';
					width: 90%;
					height: 1px;
					border-bottom: 2px solid #9cc2df;
					display: block;
					top: 85%;
					right: 7%;
					position: absolute;
					}
					
					.burger_menu #pr-menu-inner{
						display:none;
					}
										
					#pr-burger-menu{
						    display: none;
						    height: 40px;
						    width: 30px;
						    margin-top: 17px;
						    margin-right:20px;
						    float: left;
						    position: relative;
						    z-index:10;
					}
					
					#avia_header_preview.large #pr-burger-menu{margin-top: 39px;}
					
					#pr-burger-menu span{
						display:block;
						border-top:4px solid #aaa;
						margin-top: 6px;
					}
					
					.main_nav_header .burger_menu #pr-burger-menu{
						display:block;
					}
				
					.seperator_small_border .pr-menu-single.pr-menu-single-first:after { top: 145%; }
					.seperator_big_border .pr-menu-single.pr-menu-single-first:after { top: 98%; right: 0; width: 100%;}
					.bottom_nav_header .pr-menu-single.pr-menu-single-first:after { top: 92%; right: 0%; width:100%; }
					
					.minimal_header .pr-menu-single.pr-menu-single-first:after{display:none;}
					.minimal_header #avia_header_preview{border-bottom:none;}
					.minimal_header_shadow #avia_header_preview { box-shadow: 0 2px 8px 0px rgba(0,0,0,0.1); }
					
					.bottom_nav_header #search_icon.header_searchicon{float:left; top: 10px;}
					.burger_menu #pr-burger-menu{display:block;}
					#avia_header_preview .bottom_nav_header #pr-burger-menu{ margin:0; float:right; }
					.top_nav_header #search_icon, .top_nav_header #pr-burger-menu{margin:0px 10px;}
					
					</style>
					<div class='av-header-area-preview' >
						<div id='pr-stretch-wrap' >
							<small class='live_bg_small'>{$frontendheader_label}</small>
							<div id='pr-header-style-wrap' >
								<div id='pr-phone-wrap' >
									<div id='pr-social-wrap' >
										<div id='pr-seconary-menu-wrap' >
											<div id='pr-menu-2nd'>{$iconSpan}<span class='pr-secondary-items'>ورود / ثبت نام / ...</span><span class='pr-phone-items'>تلفن: 021000</span></div>
											<div id='avia_header_preview' >
												<div id='pr-main-area' >
													<img id='pr-logo' src='" . AVIA_BASE_URL . "images/layout/logo_modern.png' alt=''/>
													<div id='pr-main-icon'>{$iconSpan}</div>
													<div id='pr-menu'>
													
													
													<span id='pr-menu-inner'><span class='pr-menu-single pr-menu-single-first'>خانه</span><span class='pr-menu-single'>درباره</span><span class='pr-menu-single'>تماس</span></span> <img id='search_icon' src='" . AVIA_BASE_URL . "images/layout/search.png'  alt='' />
													<div id='pr-burger-menu'>
														<span class='burger-top'></span>
														<span class='burger-mid'></span>
														<span class='burger-low'></span>
													</div>
													
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div id='pr-breadcrumb'>عنوان دلخواه <span class='some-breadcrumb'>خانه  &#187; مدیریت  &#187; سربرگ </span></div>
							<div id='pr-content-area'> محتوا / اسلایدشوها / ... 
							<div class='inner-content'>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.</div>
							</div>
						</div>
					</div>
					",
        "nodescription" => true
    );

//START TAB CONTAINER
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_start", "id" => "avia_tab1", "nodescription" => true, 'class' => 'avia_tab_container avia_set');
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Header layout', 'avia_framework'));
// START TAB

    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Menu and Logo Position", 'avia_framework'),
        "desc" => __("You can choose various different logo and main menu positions here", 'avia_framework'),
        "id" => "header_layout",
        "type" => "select",
        "std" => "",
        "class" => "av_2columns av_col_1",
        "no_first" => true,
        "target" => array(".av-header-area-preview::#pr-main-area::set_class"),
        "subtype" => array(__('Logo left, Menu right', 'avia_framework') => 'logo_left main_nav_header menu_right',
            __('Logo right, Menu Left', 'avia_framework') => 'logo_right main_nav_header menu_left',
            __('Logo left, Menu below', 'avia_framework') => 'logo_left bottom_nav_header menu_left',
            __('Logo right, Menu below', 'avia_framework') => 'logo_right bottom_nav_header menu_center',
            __('Logo center, Menu below', 'avia_framework') => 'logo_center bottom_nav_header menu_right',
            __('Logo center, Menu above', 'avia_framework') => 'logo_center bottom_nav_header top_nav_header menu_center',
        ));

    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Size", 'avia_framework'),
        "desc" => __("Choose a predefined header size. You can also apply a custom height to the header", 'avia_framework'),
        "id" => "header_size",
        "type" => "select",
        "std" => "",
        "class" => "av_2columns av_col_2",
        "target" => array(".av-header-area-preview::#avia_header_preview::set_class"),
        "no_first" => true,
        "subtype" => array(__('slim', 'avia_framework') => 'slim',
            __('large', 'avia_framework') => 'large',
            __('custom pixel value', 'avia_framework') => 'custom',
        ));


    $customsize = array();
    for ($x = 45; $x <= 300; $x++) {
        $customsize[$x . 'px'] = $x;
    }

    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Custom Height", 'avia_framework'),
        "desc" => __("Choose a custom height in pixels (wont be reflected in the preview above, only on your actual page)", 'avia_framework'),
        "id" => "header_custom_size",
        "type" => "select",
        "std" => "150",
        "required" => array('header_size', 'custom'),
        "no_first" => true,
        "subtype" => $customsize);


    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Style", 'avia_framework'),
        "desc" => __("Choose which header style you want to use", 'avia_framework'),
        "id" => "header_style",
        "type" => "select",
        "std" => "",
        "target" => array(".av-header-area-preview::#pr-header-style-wrap::set_class"),
        "no_first" => true,
        "subtype" => array(__('Default (with borders, active menu indicator and slightly transparent)', 'avia_framework') => '',
            __('Minimal (no borders, indicators or transparency)', 'avia_framework') => 'minimal_header',
            __('Minimal with drop shadow (no borders, indicators or transparency)', 'avia_framework') => 'minimal_header minimal_header_shadow',
        ));


    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Title and Breadcrumbs", 'avia_framework'),
        "desc" => __("Choose if and how you want to display the Title and Breadcrumb of your page. This option can be overwritten when writing/editing a page", 'avia_framework'),
        "id" => "header_title_bar",
        "type" => "select",
        "std" => "title_bar_breadcrumb",
        "target" => array(".av-header-area-preview::#pr-breadcrumb::set_class"),
        "no_first" => true,
        "subtype" => array(__('Display title and breadcrumbs', 'avia_framework') => 'title_bar_breadcrumb',
            __('Display only title', 'avia_framework') => 'title_bar',
            __('Display only breadcrumbs', 'avia_framework') => 'breadcrumbs_only',
            __('Hide both', 'avia_framework') => 'hidden_title_bar',
        ));


// END TAB
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Header behavior', 'avia_framework'));
// START TAB

    $avia_elements[] = array(
        "name" => __("Sticky Header", 'avia_framework'),
        "desc" => __("If checked the header will stick to the top of your site if user scrolls down (ignored on smartphones)", 'avia_framework'),
        "id" => "header_sticky",
        "type" => "checkbox",
        "std" => "true",
        "slug" => "header");

    $avia_elements[] = array(
        "name" => __("Shrinking Header", 'avia_framework'),
        "desc" => __("If checked the sticky header will shrink once the user scrolls down (ignored on smartphones + tablets)", 'avia_framework'),
        "id" => "header_shrinking",
        "type" => "checkbox",
        "std" => "true",
        "required" => array('header_sticky', 'header_sticky'),
        "slug" => "header");

    $avia_elements[] = array(
        "name" => __("Unstick topbar", 'avia_framework'),
        "desc" => __("If checked the small top bar above the header with social icons, secondary menu and extra information will no longer stick to the top", 'avia_framework'),
        "id" => "header_unstick_top",
        "type" => "checkbox",
        "std" => "",
        "required" => array('header_sticky', 'header_sticky'),
        "slug" => "header");


    $avia_elements[] = array(
        "name" => __("Let logo and menu position adapt to browser window", 'avia_framework'),
        "desc" => __("If checked the elements in your header will always be placed at the browser window edge, instead of matching the content width", 'avia_framework'),
        "id" => "header_stretch",
        "type" => "checkbox",
        "std" => "",
        "target" => array(".av-header-area-preview::#pr-stretch-wrap::set_class"),
        "slug" => "header");

// END TAB
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


    $avia_elements[] = array("slug" => "header", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Extra Elements', 'avia_framework'));
// START TAB


    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Social Icons", 'avia_framework'),
        "desc" => __("Choose if and where to display social icons. You can define the icons at", 'avia_framework') .
            " <a href='#goto_social'>" .
            __("Social Profiles", "avia_framework") .
            "</a>"
    ,
        "id" => "header_social",
        "type" => "select",
        "std" => "",
        "class" => "av_2columns av_col_1",
        "target" => array(".av-header-area-preview::#pr-social-wrap::set_class"),
        "no_first" => true,
        "subtype" => array(__('No social Icons', 'avia_framework') => '',
            __('Display in top bar at the left', 'avia_framework') => 'icon_active_left extra_header_active',
            __('Display in top bar at the right', 'avia_framework') => 'icon_active_right extra_header_active',
            __('Display in main header area', 'avia_framework') => 'icon_active_main',
        ));

    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Secondary Menu", 'avia_framework'),
        "desc" => __("Choose if you want to display a secondary menu and where to display it", 'avia_framework'),
        "id" => "header_secondary_menu",
        "type" => "select",
        "std" => "",
        "class" => "av_2columns av_col_2",
        "target" => array(".av-header-area-preview::#pr-seconary-menu-wrap::set_class"),
        "no_first" => true,
        "subtype" => array(__('No Secondary Menu', 'avia_framework') => '',
            __('Secondary Menu in top bar at the left', 'avia_framework') => 'secondary_left extra_header_active',
            __('Secondary Menu in top bar at the right', 'avia_framework') => 'secondary_right extra_header_active',
        ));

    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Header Phone Number/Extra Info", 'avia_framework'),
        "desc" => __("Choose if you want to display an additional phone number or some extra info in your header", 'avia_framework'),
        "id" => "header_phone_active",
        "type" => "select",
        "std" => "",
        "class" => "av_2columns av_col_1",
        "target" => array(".av-header-area-preview::#pr-phone-wrap::set_class"),
        "no_first" => true,
        "subtype" => array(__('No Phone Number/Extra Info', 'avia_framework') => '',
            __('Display in top bar at the left', 'avia_framework') => 'phone_active_left extra_header_active',
            __('Display in top bar at the right', 'avia_framework') => 'phone_active_right extra_header_active',
        ));

    $avia_elements[] = array(
        "name" => __("Phone Number or small info text", 'avia_framework'),
        "desc" => __("Add the text that should be displayed in your header here", 'avia_framework'),
        "id" => "phone",
        "type" => "text",
        "std" => "",
        "class" => "av_2columns av_col_2",
        "required" => array('header_phone_active', '{contains}phone_active'),
        "slug" => "header");


// END TAB
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_start", "id" => "avia_tab5", "nodescription" => true, 'class' => 'avia_tab avia_tab2', 'name' => __('Transparency Options', 'avia_framework'));
// START TAB
    $avia_elements[] = array("name" => __("What is header transparency", 'avia_framework'),
        "desc" => __("When creating/editing a page you can select to have the header be transparent and display the content (usually a fullwidth slideshow or a fullwidth image) beneath. In those cases you will usually need a different Logo and Main Menu color which can be set here.", 'avia_framework') . "<br/><a class='av-modal-image' href='" . get_template_directory_uri() . "/images/framework-helper/header_transparency.jpg'>" . __('(Show example Screenshot)', 'avia_framework') . "</a>",
        "id" => "transparency_description",
        "std" => "",
        "slug" => "header",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Transparency Logo", 'avia_framework'),
        "desc" => __("Upload a logo image, or enter the URL or ID of an image if its already uploaded. (Leave empty to use the default logo)", 'avia_framework'),
        "id" => "header_replacement_logo",
        "type" => "upload",
        "label" => __("Use Image as logo", 'avia_framework'));


    $avia_elements[] = array(
        "slug" => "header",
        "name" => __("Transparency menu color", 'avia_framework'),
        "desc" => __("Menu color for transparent header (Leave empty to use the default color)", 'avia_framework'),
        "id" => "header_replacement_menu",
        "type" => "colorpicker",
        "std" => ""
    );

// END TAB
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "avia_tab5_end", "nodescription" => true);


//END TAB CONTAINER
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "avia_tab_container_end", "nodescription" => true);


// close conditional
    $avia_elements[] = array("slug" => "header", "type" => "visual_group_end", "id" => "header_conditional_close", "nodescription" => true);


    /*social settings*/

    $avia_elements[] = array("name" => __("Your social profiles", 'avia_framework'),
        "desc" => __("You can enter links to your social profiles here. Afterwards you can choose where to display them by activating them in the respective area", 'avia_framework') . " (" . __("e.g:", 'avia_framework') . " <a href='#goto_layout'>" . __("General Layout", 'avia_framework') . "</a>, <a href='#goto_header'>" . __("Header", 'avia_framework') . "</a>, <a href='#goto_footer'>" . __("Footer", 'avia_framework') . "</a> )",
        "id" => "socialdescription",
        "std" => "",
        "slug" => "social",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "type" => "group",
        "id" => "social_icons",
        "slug" => "social",
        "linktext" => "+",
        "deletetext" => "×",
        "blank" => true,
        "nodescription" => true,
        "std" => array(
            array('social_icon' => 'twitter', 'social_icon_link' => 'https://twitter.com/kriesi'),
            array('social_icon' => 'dribbble', 'social_icon_link' => 'https://dribbble.com/kriesi'),
        ),
        'subelements' => array(

            array(
                "name" => __("Social Icon", 'avia_framework'),
                "desc" => "",
                "id" => "social_icon",
                "type" => "select",
                "slug" => "sidebar",
                "class" => "av_2columns av_col_1",
                "subtype" => apply_filters('avf_social_icons_options', array(

                    '500px' => 'five_100_px',
                    'Behance' => 'behance',
                    'Dribbble' => 'dribbble',
                    'Facebook' => 'facebook',
                    'Flickr' => 'flickr',
                    'Instagram' => 'instagram',
                    'LinkedIn' => 'linkedin',
                    'Pinterest' => 'pinterest',
                    'Reddit' => 'reddit',
                    'Skype' => 'skype',
                    'Soundcloud' => 'soundcloud',
                    'Tumblr' => 'tumblr',
                    'Twitter' => 'twitter',
                    'Vimeo' => 'vimeo',
                    'Vk' => 'vk',
                    'Xing' => 'xing',
                    'Yelp' => 'yelp',
                    'YouTube' => 'youtube',
                    'WhatsApp' => 'whatsapp',
                    __('Special: RSS (add RSS URL, leave blank if you want to use default WordPress RSS feed)', 'avia_framework') => 'rss',
                    __('Special: Email Icon (add your own URL to link to a contact form)', 'avia_framework') => 'mail',

                ))),

            array(
                "name" => __("Social Icon URL:", 'avia_framework'),
                "desc" => "",
                "id" => "social_icon_link",
                "type" => "text",
                "slug" => "sidebar",
                "class" => "av_2columns av_col_2"),
        )
    );


    /*footer settings*/


    $avia_elements[] = array(
        "slug" => "footer",
        "name" => __("Default Footer &amp; Socket Settings", 'avia_framework'),
        "desc" => __("Do you want to display the footer widgets &amp; footer socket or a page content as footer? This default setting can be changed individually for each page.", 'avia_framework'),
        "id" => "display_widgets_socket",
        "type" => "select",
        "std" => "all",
        "no_first" => true,
        "subtype" => array(
            __('Widget based footer options', 'avia_framework') => array(
                __('Display the footer widgets & socket', 'avia_framework') => 'all',
                __('Display only the footer widgets (no socket)', 'avia_framework') => 'nosocket',
                __('Display only the socket (no footer widgets)', 'avia_framework') => 'nofooterwidgets',
                __("Don't display the socket & footer widgets", 'avia_framework') => 'nofooterarea',
            ),

            __('Page based Footer options', 'avia_framework') => array(
                __('Select a page to display as footer and socket', 'avia_framework') => 'page_in_footer_socket',
                __('Select a page to display as footer (no socket)', 'avia_framework') => 'page_in_footer',
            )
        )
    );

    $avia_elements[] = array(
        "slug" => "footer",
        "name" => __("Select page", 'avia_framework'),
        "desc" => __("Select a page to display the content of this page in the footer area. You may also use pages created with the advanced layout builder.", 'avia_framework'),
        "id" => "footer_page",
        "type" => "select",
        "subtype" => 'page',
        "with_first" => true,
        "required" => array('display_widgets_socket', '{contains_array}page_in_footer_socket;page_in_footer'),
        "std" => "",
        "class" => "avia-style",
    );


    $avia_elements[] = array(
        "slug" => "footer",
        "name" => __("Footer Columns", 'avia_framework'),
        "desc" => __("How many columns should be displayed in your footer", 'avia_framework'),
        "id" => "footer_columns",
        "required" => array('display_widgets_socket', '{contains_array}all;nosocket'),
        "type" => "select",
        "std" => "4",
        "subtype" => array(
            __('1', 'avia_framework') => '1',
            __('2', 'avia_framework') => '2',
            __('3', 'avia_framework') => '3',
            __('4', 'avia_framework') => '4',
            __('5', 'avia_framework') => '5'));

    $avia_elements[] = array(
        "slug" => "footer",
        "name" => __("Copyright", 'avia_framework'),
        "desc" => __("Add a custom copyright text at the bottom of your site. eg:", 'avia_framework') . "<br/><strong>&copy; " . __('Copyright', 'avia_framework') . "  - " . get_bloginfo('name') . "</strong>",
        "id" => "copyright",
        "required" => array('display_widgets_socket', '{contains_array}all;nofooterwidgets;page_in_footer_socket'),
        "type" => "text",
        "std" => ""

    );


    $avia_elements[] = array(
        "name" => __("Social Icons", 'avia_framework'),
        "desc" => __("Check to display the social icons defined in", 'avia_framework') .
            " <a href='#goto_social'>" .
            __("Social Profiles", 'avia_framework') .
            "</a> " .
            __("in your socket", 'avia_framework'),
        "id" => "footer_social",
        "required" => array('display_widgets_socket', '{contains_array}all;nofooterwidgets;page_in_footer_socket'),
        "type" => "checkbox",
        "std" => "",
        "slug" => "footer"
    );


    /*blog settings*/

    $avia_elements[] = array(
        "slug" => "blog",
        "name" => __("Blog Styling", 'avia_framework'),
        "desc" => __("Choose the blog styling here.", 'avia_framework'),
        "id" => "blog_global_style",
        "type" => "select",
        "std" => "",
        "no_first" => true,
        "subtype" => array(
            __('Default (Business)', 'avia_framework') => '',
            __('Elegant', 'avia_framework') => 'elegant-blog',
            __('Modern Business', 'avia_framework') => 'elegant-blog modern-blog',
        ));


    $avia_elements[] = array(
        "slug" => "blog",
        "name" => __("Blog Layout", 'avia_framework'),
        "desc" => __("Choose the default blog layout here.", 'avia_framework') . "<br/><br/>" . __("You can either choose a predefined layout or build your own blog layout with the advanced layout editor", 'avia_framework'),
        "id" => "blog_style",
        "type" => "select",
        "std" => "single-small",
        "no_first" => true,
        "subtype" => array(
            __('Multi Author Blog (displays Gravatar of the article author beside the entry and feature images above)', 'avia_framework') => 'multi-big',
            __('Single Author, small preview Pic (no author picture is displayed, feature image is small)', 'avia_framework') => 'single-small',
            __('Single Author, big preview Pic (no author picture is displayed, feature image is big)', 'avia_framework') => 'single-big',
            __('Grid Layout', 'avia_framework') => 'blog-grid',
            __('List Layout - Simple (Title and meta information only)', 'avia_framework') => 'bloglist-simple',
            __('List Layout - Compact (Title and icon only)', 'avia_framework') => 'bloglist-compact',
            __('List Layout - Excerpt (Title, meta information and excerpt only)', 'avia_framework') => 'bloglist-excerpt',
            __('Use the advance layout editor to build your own blog layout (simply edit the page you have chosen in Enfold->Theme Options as a blog page)', 'avia_framework') => 'custom',
        ));


    $avia_elements[] = array("slug" => "blog", "type" => "visual_group_start", "id" => "avia_share_links_start", "nodescription" => true);

    $avia_elements[] = array("name" => __("Single Post Options", 'avia_framework'),
        "desc" => __("Here you can set options that affect your single blog post layout", 'avia_framework'),
        "id" => "widgetdescription",
        "std" => "",
        "slug" => "blog",
        "type" => "heading",
        "nodescription" => true);

    $avia_elements[] = array(
        'slug' => 'blog',
        'name' => __('Single Post Navigation', 'avia_framework'),
        'desc' => __('Select to disable or enable the post navigation that links to the next/previous post on single entries. Setting is also used for portfolio. Use filter avf_post_nav_settings to customize.', 'avia_framework'),
        'id' => 'disable_post_nav',
        'type' => 'select',
        'no_first' => true,
        'std' => '',
        'subtype' => array(
            __('Enable post navigation', 'avia_framework') => '',
            __('Disable post navigation', 'avia_framework') => 'disable_post_nav',
            __('Loop post navigation', 'avia_framework') => 'loop_post_nav'
        )
    );

    $avia_elements[] = array(
        "slug" => "blog",
        "name" => __("Single Post Style", 'avia_framework'),
        "desc" => __("Choose the single post style here.", 'avia_framework'),
        "id" => "single_post_style",
        "type" => "select",
        "std" => "single-big",
        "no_first" => true,
        "subtype" => array(__('Single post with small preview image (featured image)', 'avia_framework') => 'single-small',
            __('Single post with big preview image (featured image)', 'avia_framework') => 'single-big',
            __('Multi Author Blog (displays Gravatar of the article author beside the entry and feature images above)', 'avia_framework') => 'multi-big'
        ));


    $avia_elements[] = array(
        "slug" => "blog",
        "name" => __("Related Entries", 'avia_framework'),
        "desc" => __("Choose if and how you want to display your related entries. (Related entries are based on tags. If a post does not have any tags then no related entries will be shown)", 'avia_framework'),
        "id" => "single_post_related_entries",
        "type" => "select",
        "std" => "av-related-style-tooltip",
        "no_first" => true,
        "subtype" => array(
            __('Show thumbnails and display post title by tooltip', 'avia_framework') => 'av-related-style-tooltip',
            __('Show thumbnail and post title by default', 'avia_framework') => 'av-related-style-full',
            __('Disable related entries', 'avia_framework') => 'disabled'
        )
    );


    $avia_elements[] = array("name" => __("Blog meta elements", 'avia_framework'),
        "desc" => __("You can choose to hide some of the default Blog elements here:", 'avia_framework'),
        "id" => "widgetdescription",
        "std" => "",
        "slug" => "blog",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "name" => __("Blog Post Author", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-author",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_1",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Blog Post Comment Count", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-comments",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("Blog Post Category", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-category",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Blog Post Date", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-date",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_1",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Blog Post Allowed HTML Tags", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-html-info",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("Blog Post Tags", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "blog-meta-tag",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_3",
        "slug" => "blog");


    $avia_elements[] = array("slug" => "blog", "type" => "visual_group_end", "id" => "avia_share_links_start", "nodescription" => true);

    $avia_elements[] = array("slug" => "blog", "type" => "visual_group_start", "id" => "avia_share_links_start", "nodescription" => true);

    $avia_elements[] = array("name" => __("Share links at the bottom of your blog post", 'avia_framework'),
        "desc" => __("The theme allows you to display share links to various social networks at the bottom of your blog posts. Check which links you want to display:", 'avia_framework'),
        "id" => "widgetdescription",
        "std" => "",
        "slug" => "blog",
        "type" => "heading",
        "nodescription" => true);


    $avia_elements[] = array(
        "name" => __("Facebook link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_facebook",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_1",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Twitter link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_twitter",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("WhatsApp link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_whatsapp",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("Pinterest link ", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_pinterest",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_1",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("Reddit link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_reddit",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("LinkedIn link ", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_linkedin",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Tumblr link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_tumblr",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_1",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("VK link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_vk",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");


    $avia_elements[] = array(
        "name" => __("Email link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_mail",
        "type" => "checkbox",
        "std" => "true",
        "class" => "av_3col av_col_2",
        "slug" => "blog");

    $avia_elements[] = array(
        "name" => __("Yelp link", 'avia_framework'),
        "desc" => __("Check to display", 'avia_framework'),
        "id" => "share_yelp",
        "type" => "checkbox",
        "std" => "",
        "class" => "av_3col av_col_1",
        "slug" => "blog");


    $avia_elements[] = array("slug" => "blog", "type" => "visual_group_end", "id" => "avia_share_links_end", "nodescription" => true);


    $avia_elements[] = array("name" => __("Import demo files", 'avia_framework'),
        "desc" => __("If you are new to wordpress or have problems creating posts or pages that look like the Theme Demo you can import dummy posts and pages here that will definitely help to understand how those tasks are done.", 'avia_framework') . "<br/><br/><strong class='av-text-notice'>" .
            __("Notice: If you want to completely remove a demo installation after importing it, you can use a plugin like", 'avia_framework') . " <a target='_blank' href='https://wordpress.org/plugins/wordpress-reset/' rel='noopener noreferrer'>WordPress Reset</a></strong>"
    ,
        "id" => "widgetdescription",
        "std" => "",
        "slug" => "demo",
        "type" => "heading",
        "nodescription" => true);


    if (!current_theme_supports('avia_disable_dummy_import')) {


        $what_get = __("What you get:", 'avia_framework');
        $online_demo = __("Online Demo", 'avia_framework');

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Default Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(for shop functionality)", 'avia_framework') . "</li>"
                . "<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank' rel='noopener noreferrer'>BBPress</a> " . __("(for forum functionality)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("A few", 'avia_framework') . "</li>"
                . "</ul>",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/default.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Enfold 2017", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-2017/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(for shop functionality)", 'avia_framework') . "</li>"
                . "<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank' rel='noopener noreferrer'>BBPress</a> " . __("(for forum functionality)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/enfold-2017",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/enfold-2017.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Small Business - Flat Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-business-flat/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/business-flat",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/business-flat.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Startup Business Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-startup/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/startup",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/startup.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: One Page Portfolio Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-one-page-portfolio/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/portfolio-one-page",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/one-page-portfolio.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Minimal Portfolio Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-minimal-portfolio/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/portfolio-minimal",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/portfolio-minimal.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Elegant Portfolio Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-elegant-portfolio/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/elegant-portfolio",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/elegant-portfolio.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Photography Portfolio Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-photography/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(if you want to sell photos online)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/photography",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/photography.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Minimal Photography Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-minimal-photography/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/minimal-photography",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/minimal-photography.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Dark Photography Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-dark-photography/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/dark-photography",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/dark-photography.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Creative Studio Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-creative-studio/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/creative-studio",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/creative-studio.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: One Page Agency Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-one-page-agency/' target='_blank'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/agency-onepage",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/agency-onepage.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Medical Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-medical/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/medical",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/medical.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Shop Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-shop/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Required Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(needs to be active to install the demo)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/shop",
            "id" => "import",
            "type" => "import",
            "exists" => array("WooCommerce", __("The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo", 'avia_framework')),
            "image" => "includes/admin/demo_files/demo_images/shop.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Restaurant Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-restaurant/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(if you want to provide online ordering and delivery)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/restaurant",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/restaurant.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Restaurant One Page Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-restaurant-one-page/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(if you want to provide online ordering and delivery)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/restaurant-one-page",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/restaurant-onepage.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: One Page Wedding Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-wedding/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/wedding",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/wedding.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Construction Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-construction/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/construction",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/construction.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Church Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-church/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Required Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='https://wordpress.org/plugins/the-events-calendar/' target='_blank' rel='noopener noreferrer'>The Events Calendar</a> "
                . __("(needs to be active to install the demo)", 'avia_framework') . "</li>"
                . "<li>or <a href='http://mbsy.co/6cr37' target='_blank' rel='noopener noreferrer'>The Events Calendar PRO</a></li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",

            'files' => "/includes/admin/demo_files/church",
            "id" => "import",
            "type" => "import",
            "exists" => array("Tribe__Events__Main", __("The Events Calendar Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo", 'avia_framework')),
            "image" => "includes/admin/demo_files/demo_images/church.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Simple Blog Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-blog/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/blog",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/blog.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Lifestyle Blog Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-lifestyle-blog/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/blog-lifestyle",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/blog-lifestyle.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: 'Coming Soon' Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-coming-soon/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/coming_soon",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/coming-soon.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: 'Landing Page' Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-landing-page/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/landing",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/landing.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Travel Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-travel/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Required Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(needs to be active to install the demo)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce Bookings</a> " . __("(needs to be active to allow date based bookings)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/travel",
            "id" => "import",
            "type" => "import",
            "exists" => array("WooCommerce", __("The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo", 'avia_framework')),
            "image" => "includes/admin/demo_files/demo_images/travel.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Hotel Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-hotel/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Required Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a> " . __("(needs to be active to install the demo)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce Bookings</a> " . __("(needs to be active to allow date based bookings)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/hotel",
            "id" => "import",
            "type" => "import",
            "exists" => array("WooCommerce", __("The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo", 'avia_framework')),
            "image" => "includes/admin/demo_files/demo_images/hotel.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Spa Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-spa/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a></li>"
                . "<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce Bookings</a> " . __("(needs to be active to allow date based bookings)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/spa",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/spa.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Law Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-law/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/law",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/law.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Consulting Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-consulting/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/consulting",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/consulting.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Résumé Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-resume/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/resume",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/resume.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: GYM Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-gym/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/gym",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/gym.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Health Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-health-coach/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/health",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/health.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: App Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-app/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/app",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/app.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Gaming Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-gaming/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/gaming",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/gaming.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: DJ Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-dj/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/dj",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/dj.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Band Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-band/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='http://woocommerce.com/?ref=84' target='_blank' rel='noopener noreferrer'>WooCommerce</a></li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/band",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/band.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Freelancer Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-freelancer/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/freelancer",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/freelancer.jpg"
        );


        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Visual Artist Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-visual-artist/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("None", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/visual-artist",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/visual-artist.jpg"
        );

        $avia_elements[] = array(
            "slug" => "demo",
            "name" => __("Import: Knowledgebase Demo", 'avia_framework'),
            "desc" => "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-knowledgebase-demo/' target='_blank' rel='noopener noreferrer'>{$online_demo}</a></strong></p>"
                . "<h4 class='av-before-plugins'>" . __("Recommended Plugins:", 'avia_framework') . "</h4><ul>"
                . "<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank' rel='noopener noreferrer'>BBPress</a> " . __("(for forum functionality)", 'avia_framework') . "</li>"
                . "</ul>"
                . "<h4 class='av-before-plugins'>" . __("Demo Images included:", 'avia_framework') . "</h4><ul>"
                . "<li>" . __("All", 'avia_framework') . "</li>"
                . "</ul>",
            'files' => "/includes/admin/demo_files/knowledgebase",
            "id" => "import",
            "type" => "import",
            "image" => "includes/admin/demo_files/demo_images/knowledgebase.jpg"
        );

    }
} else {
    $avia_elements[] = array(
        "name" => __('For using theme options, you must activate Enfold.', 'avia_framework'),
        "desc" => __('To activate Enfold, you have to enter the license code that was created for you when you purchased the theme in the Activate Enfold menu. If you do not have the license for any reason, go to the downloads section in the Zhaket dashboard, the license created in this section will be displayed to you, which you can copy and use.', 'avia_framework'),
        "id" => "frontpage",
        "std" => "",
        "slug" => "avia",
        "type" => "heading",
        "nodescription" => true
    );
}