<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Page/Post Title
 * Displays the page/post title with optional subheadings.
 */
 
add_action('wp_head','page_title_style');
function page_title_style( ){
	echo '<style>span.sep:last-child {display:none !important;}</style>';
	}
 
 
// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }



if ( !class_exists( 'avia_page_title' ) ) 
{
	class avia_page_title extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Page/Post Title', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= AviaBuilder::$path['imagesURL']."sc-heading.png";
				$this->config['order']		= 99;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'page_title';
				$this->config['modal_data'] = array('modal_class' => 'largescreen');
				$this->config['tooltip'] 	= __('Displays the page/post title with optional subheadings.', 'avia_framework' );
				$this->config['preview'] 	= false;
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				global $product;
				$prod_title = $product->post->post_title;
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					 array(	
							"name" 	=> __("Heading Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of heading you want to display.", 'avia_framework' ),
							"id" 	=> "tag",
							"type" 	=> "select",
							"std" 	=> "h2",
							"subtype" => array("H1"=>'h1',"H2"=>'h2',"H3"=>'h3',"H4"=>'h4',"H5"=>'h5',"H6"=>'h6')
							), 
							
					
					array(	
							"name" 	=> __("Heading Style", 'avia_framework' ),
							"desc" 	=> __("Select a heading style", 'avia_framework' ),
							"id" 	=> "style",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Style", 'avia_framework' )=>'',  __("Heading Style Modern (left)", 'avia_framework' )=>'blockquote modern-quote' , __("Heading Style Modern (centered)", 'avia_framework' )=>'blockquote modern-quote modern-centered', __("Heading Style Classic (centered, italic)", 'avia_framework' )=>'blockquote classic-quote')
							),   
				            
							
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your Heading in Pixel", 'avia_framework' ),
				            "id" 	=> "size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(20,90,1, array( __("Default Size", 'avia_framework' )=>'')),
				            //"required" => array('style','not',''),
				            "std" => ""),
				            				            
				     array(	
							"name" 	=> __("Subheading", 'avia_framework' ),
							"desc" 	=> __("Add an extra descriptive subheading above or below the actual heading.", 'avia_framework' ),
							"id" 	=> "subheading_active",
							"type" 	=> "select",
							"std" 	=> "",
				            //"required" => array('style','not',''),
							"subtype" => array( __("No Subheading", 'avia_framework' )=>'no_sub',  __("Display Post Meta", 'avia_framework' )=>'post_meta', __("Display Portfolio Item Category", 'avia_framework' )=>'port_cats',  __("Display Custom Subheading", 'avia_framework' )=>'subheading_below'),
							),
							
					array(	
							"name" 	=> __("Meta Links", 'avia_framework' ),
							"desc" 	=> __("Include links to each meta archive?", 'avia_framework' ),
							"id" 	=> "port_cat_links",
							"std" 	=> __("yes_links", 'avia_framework' ),
							"required" => array('subheading_active','equals','port_cats'),
							"type" 	=> "select",
							"subtype" => array( __("No Links", 'avia_framework' )=>'no_links',  __("Include Links", 'avia_framework' )=>'yes_links'),
							),  
							
					array(	
							"name" 	=> __("Meta Links", 'avia_framework' ),
							"desc" 	=> __("Include links to each meta archive?", 'avia_framework' ),
							"id" 	=> "post_cat_links",
							"std" 	=> __("yes_links", 'avia_framework' ),
							"required" => array('subheading_active','equals','post_meta'),
							"type" 	=> "select",
							"subtype" => array( __("No Links", 'avia_framework' )=>'no_links',  __("Include Links", 'avia_framework' )=>'yes_links'),
							),  
							
					array(
								"name" 	=> __("Hide Meta Elements",'avia_framework' ),
								"desc" 	=> __("These options only apply when this element is used on a blog post.", 'avia_framework' ),
								"type" 	=> "heading",
								"required" => array('subheading_active','equals','post_meta'),
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide Post Date", 'avia_framework'),
										"id" 	=> "post_date_hide",
										"std" 	=> "",
										"required" => array('subheading_active','equals','post_meta'),
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide Post Author Name", 'avia_framework'),
										"id" 	=> "post_author_hide",
										"std" 	=> "",
										"required" => array('subheading_active','equals','post_meta'),
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide Post Comment Count", 'avia_framework'),
										"id" 	=> "comment_count_hide",
										"std" 	=> "",
										"required" => array('subheading_active','equals','post_meta'),
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide Post Category List", 'avia_framework'),
										"id" 	=> "post_cat_hide",
										"std" 	=> "",
										"required" => array('subheading_active','equals','post_meta'),
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),		 					  
							  
					array(
						"name" 	=> __("Subheading Text",'avia_framework' ),
						"desc" 	=> __("Add your subheading here",'avia_framework' ),
						"id" 	=> "content",
						"type" 	=> "textarea",
						"required" => array('subheading_active', 'equals','subheading_below'),
						"std" 	=> ""),   
						
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your subeading in Pixel", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,40,1),
				            "std" => "16"), 
				            	
                    array(	"name" 	=> __("Padding Bottom", 'avia_framework' ),
							"desc" 	=> __("Bottom Padding in pixel", 'avia_framework' ),
				            "id" 	=> "padding",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,120,1),
				            "std" => "10"),  
				     
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-heading')
						),
						
					array(	
							"name" 	=> __("Subheading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "subcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-subheading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_subfont",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('subcolor','equals','custom-color-subheading')
						),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
								
									
								array(
									"name" 	=> __("Heading Font Size",'avia_framework' ),
									"desc" 	=> __("Set the font size for the heading, based on the device screensize.", 'avia_framework' ),
									"type" 	=> "heading",
									"description_class" => "av-builder-note av-neutral",
									),
										
									array(	"name" 	=> __("Font Size for medium sized screens", 'avia_framework' ),
						            "id" 	=> "av-medium-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'' , __("Hidden", 'avia_framework' )=>'hidden' ), "px"),
						            "std" => ""),
						            
						            array(	"name" 	=> __("Font Size for small screens", 'avia_framework' ),
						            "id" 	=> "av-small-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
									array(	"name" 	=> __("Font Size for very small screens", 'avia_framework' ),
						            "id" 	=> "av-mini-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
						            
						        array(
									"name" 	=> __("Subheading Font Size",'avia_framework' ),
									"desc" 	=> __("Set the font size for the subheading, based on the device screensize.", 'avia_framework' ),
									"type" 	=> "heading",
									"description_class" => "av-builder-note av-neutral",
									),
										
									array(	"name" 	=> __("Font Size for medium sized screens", 'avia_framework' ),
						            "id" 	=> "av-medium-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
						            array(	"name" 	=> __("Font Size for small screens", 'avia_framework' ),
						            "id" 	=> "av-small-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
									array(	"name" 	=> __("Font Size for very small screens", 'avia_framework' ),
						            "id" 	=> "av-mini-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),    
				
							
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('tag' => 'h2', 'padding' => '5', 'color'=>'', 'subcolor' =>'', 'style'=>'', 'custom_font'=>'', 'custom_subfont'=>'', 'size'=>'', 'subheading_active' => '', 'post_cat_links' => '', 'port_cat_links' => '', 'subheading_size'=>'', 'post_date_hide'=>'', 'post_author_hide'=>'', 'comment_count_hide'=>'', 'post_cat_hide'=>''), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		$subheading = "";
        		$border_styling = "";
        		$before = $after = "";
        		$class   = $meta['el_class'];
        		$subheading_extra = "";
        		

        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
					       			
        			//apply the padding bottom styling
	        		$styling .= "padding-bottom:{$padding}px;";
	        		
	        		// if the color is a custom hex value add the styling for both border and font
	        		if($color == "custom-color-heading" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font};";
	        			$border_styling = "style='border-color:{$custom_font}'";
	        			$subheading_extra = "av_custom_color";
	        		}
					
					if($subcolor == "custom-color-subheading" && $custom_subfont)  
	        		{
	        			$substyling .= "color:{$custom_subfont} !important;";
	        		}
					
					if($suffix_color == "custom-color-suffix" && $custom_suffix)  
	        		{
						$suffix_styling .= "color:{$custom_suffix};";
					}
					
					if($border_color == "custom-color-border" && $custom_border)  
	        		{
						$border_styling .= "border-color:{$custom_border};";
					}
	        		
	        		// if a custom font size is set apply it to the container and also apply the inherit class so the actual heading uses the size
	        		if(!empty($style) && !empty($size)) { $styling .= "font-size:{$size}px;"; $class .= " av-inherit-size";}
	        		
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
	        		
	        		//check if we got a subheading
					if( $subheading_active == 'no_sub' )
	        		{
										
					//html markup
					$page_title = get_the_title();

	        		$output .= "<div class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$page_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
	        		$output .= "</div>";
        		
        		
        		return $output;
						
	        		}
	        		if( $subheading_active == 'subheading_below' && !empty( $content ) )
	        		{
	        			
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='margin-top:5px !important; font-size:{$subheading_size}px; {$substyling}'>".$content."</div>";
	        		
	        			$after = $content;
						
					//html markup
					$page_title = get_the_title();

	        		$output .= "<div class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$page_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
	        		$output .= 		$after;
	        		$output .= "</div>";
        		
        		
        		return $output;
						
	        		}
					
					if( (($subheading_active == 'port_cats') && ($port_cat_links == 'no_links')) || (($subheading_active == 'post_meta') && ($post_cat_links == 'no_links')) )
	        		{
								
					//html markup
					$page_title = get_the_title();
					$post_cat = get_the_terms( $post->ID , 'category');
 					$port_cat = get_the_terms( $post->ID , 'portfolio_entries');
					if ($post_date_hide) {$mhide_postdate = 'style="display:none;"';};
					if ($post_author_hide) {$mhide_byline = 'style="display:none;"';};
					if ($comment_count_hide) {$mhide_comments = 'style="display:none;"';};
					if ($post_cat_hide) {$mhide_cats= 'style="display:none;"';};

	        		$output .= "<div class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$page_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
					if (is_singular ('portfolio')){
					$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='margin-top:5px !important; font-size:{$subheading_size}px; {$substyling}'>";
					foreach( $port_cat as $category ) 
    				$output .= "<span class='meow' style='font-variant: small-caps; text-transform:lowercase; font-size:125%;'>".$category->name . "</span><span class='sep'> &middot; </span>";
					}
					if (is_singular ('post')){
					$comments_count = get_comments_number();
					if ($comments_count == '0') {$comments = get_comments_number(). ' comments';}
					if ($comments_count == '1') {$comments = get_comments_number(). ' comment';}
					if ($comments_count >= '2') {$comments = get_comments_number(). ' comments';}
					$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='text-transform:uppercase; margin-top:5px !important; font-size:{$subheading_size}px; {$substyling}'><span {$mhide_postdate}><span class='postdate'></span>".get_the_date()." &nbsp; &vellip; &nbsp; </span><span {$mhide_byline}><span class='byline'>by ".get_the_author()."</span> &nbsp; &vellip; &nbsp; </span><span {$mhide_comments}><span class='comment_count'>".$comments."</span> &nbsp; &vellip; &nbsp; </span><span {$mhide_cats}>";
					foreach( $post_cat as $category ) {
    				$output .= "<span class='meow'>".$category->name . "</span><span class='sep'> &middot; </span>";
					}}
	        		$output .= "</span></div>";
	        		$output .= "</div>";
        		
        		
        		return $output;
						
	        		}
					
	        		if( (($subheading_active == 'port_cats') && ($port_cat_links == 'yes_links')) || (($subheading_active == 'post_meta') && ($post_cat_links == 'yes_links')) )
	        		{
								
					//html markup
					$page_title = get_the_title();
					$post_cat = get_the_terms( $post->ID , 'category');
 					$port_cat = get_the_terms( $post->ID , 'portfolio_entries');
					if ($post_date_hide) {$mhide_postdate = 'style="display:none;"';};
					if ($post_author_hide) {$mhide_byline = 'style="display:none;"';};
					if ($comment_count_hide) {$mhide_comments = 'style="display:none;"';};
					if ($post_cat_hide) {$mhide_cats= 'style="display:none;"';};

	        		$output .= "<div class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$page_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
					if (is_singular ('portfolio')){
					$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='margin-top:5px !important; font-size:{$subheading_size}px; {$substyling}'>";
					foreach( $port_cat as $category ) {
    				$output .= "<a class='meow-link' style='font-variant: small-caps; text-transform:lowercase; font-size:125%;' href='".get_term_link( $category )."'>".$category->name . "</a><span class='sep'> &middot; </span>";
					}}
					if (is_singular ('post')){
					$comments_count = get_comments_number();
					if ($comments_count == '0') {$comments = get_comments_number(). ' comments';}
					if ($comments_count == '1') {$comments = get_comments_number(). ' comment';}
					if ($comments_count >= '2') {$comments = get_comments_number(). ' comments';}
					$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='text-transform:uppercase; margin-top:5px !important; font-size:{$subheading_size}px; {$substyling}'><span {$mhide_postdate}><span class='postdate'></span>".get_the_date()." &nbsp; &vellip; &nbsp; </span><span {$mhide_byline}><span class='byline'>by</span> <a class='author' href='".get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )."'/>".get_the_author()."</a> &nbsp; &vellip; &nbsp; </span><span {$mhide_comments}><span class='comment_count'><a href='#comments'>".$comments."</a></span> &nbsp; &vellip; &nbsp; </span><span {$mhide_cats}>";
					foreach( $post_cat as $category ) {
    				$output .= "<a class='meow-link' href='".get_term_link( $category )."'>".$category->name . "</a><span class='sep'> &middot; </span>";
					}}
	        		$output .= "</span></div>";
	        		$output .= "</div>";
        		
        		
        		return $output;
						
	        		}
	        		
        	}
			
			
	}
}
