<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Artwork Frame
 * Displays artwork product in a nice CSS frame.
 */

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('ss_wc_artframe', 'avia_please_install_woo');
	return;
}
 
if ( !class_exists( 'spiderfly_wc_artframe' ) )
{
	class spiderfly_wc_artframe extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Artwork Product Frame', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."artframe.png";
			$this->config['order']		= 92;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'ss_wc_artframe';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays artwork product in a nice CSS frame.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= false;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$template_url = get_stylesheet_directory_uri();
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Content",'avia_framework' ),
							'nodescription' => true
						), 
				
					array(
							"name" 	=> __("<strong style='color:red;'>REQUIRED</strong>",'avia_framework' ),
							"desc" 	=> __("Regardless if you wish to have the artwork title displayed on the front-end, an unique title is required. We will use it to provide each element instance a unique ID in order to retain your custom styling of each instance.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
								),
				
					array(
							"name" 	=> __("Artwork Title", 'avia_framework' ),
							"desc" 	=> __("Enter the artwork title here. If you leave this field blank, it will automatically use the linked product's title.", 'avia_framework' ) ,
							"id" 	=> "title",
							"std" 	=> "Scenic Vista",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(
							"name" 	=> __("Artwork Byline", 'avia_framework' ),
							"desc" 	=> __("Display the artist's name and give attribution. If left blank your site's title will be displayed here.", 'avia_framework' ) ,
							"id" 	=> "byline",
							"std" 	=> "Dee Buttersnaps",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(
							"name" 	=> __("Artwork Width", 'avia_framework' ),
							"desc" 	=> __("Display the art prodcut's width. eg. '27in or 130cm'", 'avia_framework' ) ,
							"id" 	=> "diswidth",
							"std" 	=> "",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(
							"name" 	=> __("Artwork Height", 'avia_framework' ),
							"desc" 	=> __("Display the art product's height eg '36in or 225cm'", 'avia_framework' ) ,
							"id" 	=> "disheight",
							"std" 	=> "",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(	
							"desc" 	=> __("Hide the title and byline on the front-end.", 'avia_framework'),
							"id" 	=> "byline_hide",
							"std" 	=> "display",
							"type" 	=> "select",
							"subtype" => array("Display"=>'block',"Hide"=>'none')),
						
					array(
							"name" 	=> __("Choose Image",'avia_framework' ),
							"desc" 	=> __("Either upload a new, or choose an existing image from your media library",'avia_framework' ),
							"id" 	=> "src",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> $template_url."/shortcodes/spiderfly-elements/images/scenic.jpg",), 
				
					array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "bg_pos",
							"type" 	=> "select",
							"std" 	=> "center center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
				
					array(
						"name" 	=> __("Which Product?", 'avia_framework' ),
						"desc" 	=> __("Select which product you would like to link to.", 'avia_framework' ),
						"id" 	=> "link",
						"type" 	=> "select",
						"taxonomy" => "single",
						"subtype" => "product",
						),
				
					array(	
							"name" 	=> __("Alternate Lightbox Image?", 'avia_framework' ),
							"desc" 	=> __("Choose if you would like to use the artwork image you have already chosen above for the lightbox display, or select an alternative (like a watermarked version).", 'avia_framework' ),
							"id" 	=> "altdisplay",
							"type" 	=> "select",
							"std" 	=> "none",
							"subtype" => array("None"=>'none',"Alternative Image"=>'alt-image')
							),
				
					array(
							"name" 	=> __("Choose Alternate Image",'avia_framework' ),
							"desc" 	=> __("Either upload a new, or choose an existing image from your media library as an alternate version of your artwork to display in the lightbox (zoom) modal. Such as a watermarked version.",'avia_framework' ),
							"id" 	=> "altsrc",
							"type" 	=> "image",
							"required" => array('altdisplay','equals','alt-image'),
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> "",), 
				
					array(
							"name" 	=> __("Why are the height & width required?",'avia_framework' ),
							"desc" 	=> __("The frame and mat are generated purely with CSS and require defined dimensions in order to retain the effect. Don't worry, you can define optional dimensions for tablets and phones in the screen options section.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
								),
				
					array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
							"id" 	=> "width",
							"std" 	=> "450",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
							"id" 	=> "height",
							"std" 	=> "300",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
							
				array(
						"type" 	=> "close_div",
						'nodescription' => true
					),
				
				array(
						"type" 	=> "tab",
						"name"	=> __("Colors",'avia_framework' ),
						'nodescription' => true
					),
				
					array(	
							"name" 	=> __("Frame Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "frame_color",
							"type" 	=> "colorpicker",
					   		"container_class" => 'av_half',
							"std" 	=> "#22130c",
						),
							
					array(	
							"name" 	=> __("Mat Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "mat_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#fff5e5",
						),
				
					array(	
							"name" 	=> __("Zoom Button Theme", 'avia_framework' ),
							"desc" 	=> __("Depending on the colors in the artwork displayed, the zoom button might not be easy to see. Choose between a light and dark theme.", 'avia_framework' ),
							"id" 	=> "zoomcolor",
							"type" 	=> "select",
							"std" 	=> "light",
							"subtype" => array("Light"=>'light',"Dark"=>'dark')
							),
				
					array(	
							"name" 	=> __("Title Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "title_color",
							"type" 	=> "colorpicker",
					   		"container_class" => 'av_half',
							"std" 	=> "#252525",
						),
							
					array(	
							"name" 	=> __("Byline Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "byline_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#252525",
						),
				
				array(
						"type" 	=> "close_div",
						'nodescription' => true
					),
							
				array(
						"type" 	=> "tab",
						"name"	=> __("Screen Options",'avia_framework' ),
						'nodescription' => true
					),
				
						array(
							"name" 	=> __("Tablet Dimensions",'avia_framework' ),
							"desc" 	=> __("Set the dimensions for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
				
						array(
							"name" 	=> __("Maximum Tablet Width Break Point", 'avia_framework' ),
							"desc" 	=> __("Enter the width breaking point between tablet and desktop displays.", 'avia_framework' ) ,
							"id" 	=> "tab_break",
							"std" 	=> "989",
							"type" 	=> "input"),

						array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Set the width for when viewed on a tablet.", 'avia_framework' ) ,
							"id" 	=> "twidth",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   		array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Set the height for when viewed on a tablet.", 'avia_framework' ) ,
							"id" 	=> "theight",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
								
						array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "tablet_bg_pos",
							"type" 	=> "select",
							"std" 	=> "center center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
				
						array(
							"name" 	=> __("Phone Dimensions",'avia_framework' ),
							"desc" 	=> __("Set the dimensions for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
							),
				
						array(
							"name" 	=> __("Maximum Phone Width Break Point", 'avia_framework' ),
							"desc" 	=> __("Enter the width breaking point between phone and tablet displays.", 'avia_framework' ) ,
							"id" 	=> "phone_break",
							"std" 	=> "767",
							"type" 	=> "input"),
						array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Set the width for when viewed on a phone.", 'avia_framework' ) ,
							"id" 	=> "pwidth",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   		array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Set the height for when viewed on a phone.", 'avia_framework' ) ,
							"id" 	=> "pheight",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
						array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "phone_bg_pos",
							"type" 	=> "select",
							"std" 	=> "center-center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
								
						array(
							"name" 	=> __("Element Visibility",'avia_framework' ),
							"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
							),
							
						array(	
							"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
							"id" 	=> "av-desktop-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
								
						array(	
							"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
							"id" 	=> "av-medium-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
										
						array(	
							"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
							"id" 	=> "av-small-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
										
						array(	
							"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
							"id" 	=> "av-mini-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
									
					array(
						"type" 	=> "close_div",
						'nodescription' => true
						),	
								
				array(
					"type" 	=> "close_div",
					'nodescription' => true
					),	
				

				);
		}
		
		public function is_nested_self_closing( $shortcode )
		{return true;}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('src'=>'', 'altsrc'=>'', 'title'=>'', 'byline'=>'', 'link'=>'', 'bg_pos'=>'center center', 'tablet_bg_pos'=>'center center', 'phone_bg_pos'=>'center center', 'diswidth'=>'', 'disheight'=>'', 'width'=>'', 'twidth'=>'', 'pwidth'=>'', 'height'=>'', 'theight'=>'', 'pheight'=>'', 'frame_color'=>'', 'mat_color'=>'', 'title_color'=>'', 'zoomcolor'=>'', 'byline_color'=>'', 'byline_hide'=>'', 'tab_break'=>'', 'phone_break'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			if($atts['src']){$src == $atts['src'];}else{$src == get_stylesheet_directory_uri()."/shortcodes/spiderfly-elements/images/horses.jpg";}
			
			global $product;
			$product = wc_get_product( $link );
			$price = $product->get_price();
			$prod_title = $product->post->post_title;
			if(!empty($title)) $prod_title = $title;
			if(empty($byline)) $byline = get_bloginfo( 'name' );
			
			$title_id = str_replace(' ', '_', $prod_title);
			
			$styling = "<style>
			#{$title_id} .artframe {width:{$width}px; height:{$height}px;}
			#{$title_id} .artframe:before {background-color: {$frame_color} !important;}
			#{$title_id} .artframe:after {background-color: {$mat_color} !important;}
			#{$title_id} .artframe li {background-image:url({$src});background-size:cover !important; background-position:{$bg_pos} !important; height:calc({$height}px - 14px); width:calc({$width}px - 14px);}
			</style>";
			$p1 = "1";
			$phone_break = $atts['phone_break'];
			$min_tab == $phone_break+$p1;
			
			$byline_display = $atts['byline_hide'];
			
			$tstyling = "<style>@media only screen and (min-width: {$min_tab}px),(max-width: {$tab_break}px){#{$title_id} .artframe { width:{$twidth}px !important; height:{$theight}px !important;} #{$title_id} .artframe li {height:calc({$theight}px - 14px) !important; width:calc({$twidth}px - 14px) !important; background-size:cover !important; background-position:{$tablet_bg_pos} !important;} }}</style>";
			
			$pstyling = "<style>@media only screen and (max-width: {$phone_break}px){#{$title_id} .artframe { width:{$pwidth}px !important; height:{$pheight}px !important;} #{$title_id} .artframe li {height:calc({$pheight}px - 14px) !important; width:calc({$pwidth}px - 14px) !important; background-size:cover !important; background-position:{$phone_bg_pos} !important;}}</style>";
			
			$url = get_permalink( $link );
			$currency .= get_woocommerce_currency_symbol();
			$currency = "<sup style='position:relative;font-size:75%;top:-0.2em;vertical-align:baseline;'>".$currency."</sup>";
			
			
			if(($atts['altdisplay'] == "alt-image")) {
				$zoomimg = $altsrc;
			}
			if(($atts['altdisplay'] == "none") || empty($atts['altsrc'])) {
				$zoomimg = $src;
			}
			
			$zoom = "<a rel='lightbox' data-rel='gallery-{$title_id}' class='lightbox lbzoom {$zoomcolor}' href='{$zoomimg}'><span class='av_font_icon av-icon-style- av-no-color avia-icon-pos-center'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span></a>";
			
			$dimensions = "<style>#{$title_id} .artsize .artdim:hover .artwidth {width:calc({$width}px - 7px) !important;} #{$title_id} .artsize .artdim:hover .artheight {height:calc({$height}px - 79px) !important; line-height:calc({$height}px - 79px);}</style><div class='artsize'><div class='artdim light'><span class='av_font_icon av-icon-style- av-no-color avia-icon-pos-center'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span><div class='artwidth'>{$diswidth}</div><div class='artheight'><div style='line-height:14px!important; position:relative; top:46%;'>{$disheight}</div></div></div></div>";
			
			if ( $product->is_type( 'simple' ) ) {
			$artdisplay = "<style>#{$title_id} .addcartbtn:hover .av_font_icon::after {content: 'ADD TO CART' !important;}</style><ul class='artframe'><div class='price-tag'><p class='artprice'>{$currency}{$price}</p></div>{$zoom}{$dimensions}<a href='?add-to-cart={$link}' class='addcartbtn'><span class='av_font_icon av-icon-style- av-no-color avia-icon-pos-center'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span></a><a href='".$url."'><li></li></a></ul>";
			}
			
			if ( ($product->is_type( 'variable' )) || ( $product->is_type( 'grouped' )) || ( $product->is_type( 'external' )) ) {
			$artdisplay = "<style>#{$title_id} .addcartbtn:hover .av_font_icon::after {content: 'VIEW OPTIONS' !important;}</style><ul class='artframe'><div class='price-tag'><p class='artprice'>{$currency}{$price}</p></div>{$zoom}{$dimensions}<a href='{$url}' class='addcartbtn'><span class='av_font_icon av-icon-style- av-no-color avia-icon-pos-center'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span></a><a href='".$url."'><li></li></a></ul>";
			}
							
			//html markup
	        $output = "";
			$output .= $styling;
			$output .= $tstyling;
			$output .= $pstyling;
			$output .= "<div id='{$title_id}'>{$artdisplay}<p class='art_title' style='display:{$byline_display} !important;'><i><span style='color:{$title_color};'>&quot;{$prod_title}&quot;</span> ~ by <span style='color:{$byline_color};'>{$byline}</span></i></p></div>";
	  					
			return $output;
		}
	}
}
