<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * ACF Field Display
 * Displays Advanced Custom Field values.
 */


function avia_please_install_acf()
{
	$url = network_site_url( 'wp-admin/plugin-install.php?tab=search&type=term&s=Advanced+Custom+Fields&plugin-search-input=Search+Plugins');
	$output = "<p class='please-install-woo' style='display:block; text-align:center; clear:both;'><strong>You need to install and activate the <a href='$url' style='text-decoration:underline;'>Advanced Custom Fields</a> plugin to display ACF values.</strong></p>";
	return $output;
}

if( !class_exists('acf') ) {
	add_shortcode('av_acf_value', 'avia_please_install_acf');
	return;
} 


if ( !class_exists( 'avia_sc_acf_value' ) )
{
	class avia_sc_acf_value extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('ACF Field Value', 'avia_framework' );
			$this->config['tab']		= __('ACF', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."acf-field.png";
			$this->config['order']		= 20;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'ssmed');
			$this->config['shortcode'] 	= 'av_acf_value';
			$this->config['tooltip'] 	= __('Displays Advanced Custom Field values.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					array(	
						"desc" 	=> __("Are you calling a custom field or an options field?", 'avia_framework'),
						"id" 	=> "type",
						"std" 	=> "custom_field",
						"type" 	=> "select",
						"subtype" => array("Custom Field"=>'custom_field',"Options Field"=>'option_field')),
					array(	
						"name" 	=> __("Option Field Name", 'avia_framework' ),
						"desc" 	=> __("Enter the <strong style='color:#e65100;'>field name</strong> of the ACF field, not the label, whose value you are calling.", 'avia_framework' ),
						"id" 	=> "option_name",
						"std" 	=> "",
						"required" => array('type','equals','option_field'),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Field Name", 'avia_framework' ),
						"desc" 	=> __("Enter the <strong style='color:#e65100;'>field name</strong> of the ACF field, not the label, whose value you are calling.", 'avia_framework' ),
						"id" 	=> "field_name",
						"std" 	=> "",
						"required" => array('type','equals','custom_field'),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Post ID", 'avia_framework' ),
						"desc" 	=> __("Enter a page or post ID if you want to call an ACF field value from a specific page or post that isn't this one.", 'avia_framework' ),
						"id" 	=> "post_id",
						"std" 	=> "",
						"required" => array('type','equals','custom_field'),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Optional Prefix", 'avia_framework' ),
						"desc" 	=> __("Optionally include prefix text that will display before the field text.", 'avia_framework' ),
						"id" 	=> "prefix",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Optional Suffix", 'avia_framework' ),
						"desc" 	=> __("Optionally include suffix text that will display after the field text.", 'avia_framework' ),
						"id" 	=> "suffix",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Bold Prefix", 'avia_framework' ),
						"desc" 	=> __("Optionally have the prefix text bolded.", 'avia_framework' ),
						"id" 	=> "prefix_bold",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "checkbox"),
					array(	
						"name" 	=> __("Small Suffix", 'avia_framework' ),
						"desc" 	=> __("Optionally have the suffix text wrapped in 'small' tags.", 'avia_framework' ),
						"id" 	=> "suffix_small",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "checkbox"),
					array(	
						"name" 	=> __("Field Wrapper", 'avia_framework' ),
						"desc" 	=> __("Define what element you would like to wrap the field (i.e. li or p tag). Insert the tag without <>", 'avia_framework' ),
						"id" 	=> "wrapper",
						"std" 	=> __("p", 'avia_framework' ),
						"container_class" => 'av_half',
						"type" 	=> "input"),
					array(
						"name" 	=> __("Text Size", 'avia_framework' ),
						"desc" 	=> __("Size of your field in pixels", 'avia_framework' ),
				        "id" 	=> "size",
				        "type" 	=> "select",
				        "subtype" => AviaHtmlHelper::number_array(10,25,1, array( __("Default Size", 'avia_framework' )=>'')),
						"container_class" => 'av_half',
				        "std" => ""),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('type'=>'', 'option_name'=>'', 'field_name'=>'', 'post_id'=>'', 'wrapper'=>'p', 'prefix'=>'', 'prefix_bold'=>'', 'suffix'=>'', 'suffix_small'=>'', 'size'=>''), $atts, $this->config['shortcode']));
			
			$options = $atts['option_name'];
			$field = get_field($field_name); 
			$option_post = get_field($option_name, 'option');
			$prefix = $atts['prefix'];
			$prefix_bold = $atts['prefix_bold'];
			$suffix = $atts['suffix'];
			$suffix_small = $atts['suffix_small'];
			$field_post = get_field($field_name, $post_id);
			if ($prefix_bold){$start_wrap = '<'.$wrapper.' class="'.$av_display_classes.'" style="font-size:'.$size.'px !important;"><span style="font-weight:600;">'.$prefix.'</span> ';}else{$start_wrap = '<'.$wrapper.' class="'.$av_display_classes.'" style="font-size:'.$size.'px !important;">'.$prefix.' ';}
			if ($suffix_small){$end_wrap = ' <small>'.$suffix.'</small></'.$wrapper.'>';}else{$end_wrap = ' '.$suffix.'</'.$wrapper.'>';}
			
			if (($type == 'custom_field') && $post_id){
			$output = $field_post;
			} elseif ($type == 'option_field'){
			$output = $option_post;
			} else {
			$output = $field;
			}
			$meta['el_class'];
						
			return $start_wrap.$output.$end_wrap;
		}
	}
}
