<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Movie Card
 * Displays a responsive movie info card.
 */
 

if ( !class_exists( 'ss_moviecard' ) )
{
	class ss_moviecard extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Movie Card', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."movie-card.png";
			$this->config['order']		= 24;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'ss_moviecard';
			$this->config['modal_data'] = array('modal_class' => 'ssmed');
			$this->config['tooltip'] 	= __('Displays a responsive movie info card.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Content",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Card Style", 'avia_framework' ),
							"desc" 	=> __("Choose between a fully responsive banner or lock the layout into a portrait style.", 'avia_framework' ),
							"id" 	=> "card",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "",
							"subtype" => array( __("Horizontal Banner", 'avia_framework' )=>'banner', __("Portrait Card", 'avia_framework' )=>'portrait')), 
							
					array(	
							"name" 	=> __("Title", 'avia_framework' ),
							"desc" 	=> __("Enter the title of the movie, film or TV show.", 'avia_framework' ),
							"id" 	=> "title",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(
							"name" 	=> __("Choose Poster Art Image",'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "boxart",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"container_class" => 'av_half',
							"std" 	=> AviaBuilder::$path['imagesURL']."placeholder.jpg"),
				
					array(
							"name" 	=> __("Choose Card Background Image",'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "bgart",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"container_class" => 'av_half',
							"std" 	=> AviaBuilder::$path['imagesURL']."placeholder.jpg"),
				
					array(	
							"name" 	=> __("Release Year", 'avia_framework' ),
							"desc" 	=> __("Enter the release year, estimated release date, etc. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "year",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Rating", 'avia_framework' ),
							"desc" 	=> __("Enter the media rating. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "rating",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Credits", 'avia_framework' ),
							"desc" 	=> __("Enter the director, production company or the name of anyone you would like to feature credit.", 'avia_framework' ),
							"id" 	=> "credits",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Duration", 'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "duration",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Genre", 'avia_framework' ),
							"desc" 	=> __("Enter all genres that apply using any separator you would like.", 'avia_framework' ),
							"id" 	=> "genre",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Corner Ribbon", 'avia_framework' ),
							"desc" 	=> __("Optionally have a corner ribbon to highlight a new release, news, etc. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "ribbon",
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Trailer Link", 'avia_framework' ),
							"desc" 	=> __("Link directly to a video which will display in a modal popup. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "trailer",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Trailer Button Text", 'avia_framework' ),
							"desc" 	=> __("Set the text you would like for the trailer button.", 'avia_framework' ),
							"id" 	=> "trailer_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "WATCH TRAILER",),
				
					array(	
							"name" 	=> __("Second Link", 'avia_framework' ),
							"desc" 	=> __("Optional second link. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "alt_link",
							"container_class" => 'av_half',
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(	
												__('Hide Button', 'avia_framework' ) =>'hidebtn',
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												__('Taxonomy Overview Page',  'avia_framework' )=>'taxonomy',
												),
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Second Button Text", 'avia_framework' ),
							"desc" 	=> __("Set the text you would like for the second button.", 'avia_framework' ),
							"id" 	=> "alt_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "LEARN MORE",),

					array(	
							"name" 	=> __("Description", 'avia_framework' ),
							"desc" 	=> __("Enter a brief description of the featured video.", 'avia_framework' ),
							"id" 	=> "description",
							"type" 	=> "textarea",
							"std" 	=> "",),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true),
				
					array(
							"type" 	=> "tab",
							"name"	=> __("Styling",'avia_framework' ),
							'nodescription' => true),
				
					array(	
							"name" 	=> __("Title Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the title in pixels.", 'avia_framework' ),
						    "container_class" => 'av_half',
				            "id" 	=> "title_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(16,60,1, array( __("Default Size", 'avia_framework' )=>'32')),
				            "std" => "32"),
					array(	
							"name" 	=> __("Title Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "title_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#ffffff",),
					array(	
							"name" 	=> __("Year/Rating/Credit Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the title in pixels.", 'avia_framework' ),
						    "container_class" => 'av_half',
				            "id" 	=> "credit_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(16,45,1, array( __("Default Size", 'avia_framework' )=>'20')),
				            "std" => "20"),
					array(	
							"name" 	=> __("Year/Rating/Credit Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "credit_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#9ac7fa",),
				    array(	
							"name" 	=> __("Ribbon Text Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "ribbon_text",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#fff",),
					array(	
							"name" 	=> __("Ribbon Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "ribbon_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#39d",),
				
					array(
							"type" 	=> "close_div",
							'nodescription' => true),
						
					array(
							"type" 	=> "tab",
							"name"	=> __("Screen Options",'avia_framework' ),
							'nodescription' => true),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('card'=>'', 'title'=>'', 'boxart'=>'', 'bgart'=>'', 'year'=>'', 'rating'=>'', 'credits'=>'', 'duration'=>'', 'genre'=>'', 'trailer'=>'', 'trailer_btn'=>'', 'alt_link'=>'', 'alt_btn'=>'', 'description'=>'', 'title_size'=>'', 'title_color'=>'', 'credit_size'=>'', 'credit_color'=>'', 'ribbon'=>'', 'ribbon_text'=>'', 'ribbon_color'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
					
			if(!empty($boxart)) $coverart = '<img class="boxart" src="'.$boxart.'"/>';
			if($card == 'banner'){$mingen = '<span class="minutes">'.$duration.'</span><p class="type">'.$genre.'</p></div>';}
			if($card == 'portrait'){$mingen = '</div><div class="movie_subheader"><span class="minutes">'.$duration.'</span><p class="type">'.$genre.'</p></div>';}
			if(!empty($trailer)) $trailer_link = '<a href="'.$trailer.'?iframe=true">'.$trailer_btn.'</a>';
			if($alt_link != 'hidebtn') {$second_link = '<a href="'.$alt_link.'">'.$alt_btn.'</a>';}else{$second_link = '';}
			if($ribbon) {$cornerribbon = '<div class="corner-ribbon top-right-movie sticky" style="background-color:'.$ribbon_color.'!important; color:'.$ribbon_text.'!important;">'.$ribbon.'</div>';}
			if($rating){$rating = ' &middot; '.$rating;}
			if($credits){$credits = ' &middot; '.$credits;}
			
			//html markup
	        		$output .= '<div class="movie_card" id="'.$card.'">
  <div class="info_section">
  '.$cornerribbon.'
    <div class="movie_header">
      '.$coverart.'
      <h1 style="font-size:'.$title_size.'px; color:'.$title_color.';">'.$title.'</h1>
      <h4 style="font-size:'.$credit_size.'px; color:'.$credit_color.';">'.$year.$rating.$credits.'</h4>
      '.$mingen.'
	<div class="trailer">'.$trailer_link.$second_link.'</div>
    <div class="movie_desc">
      <p class="text">'.$description.'
      </p>
    </div>
  </div>
  <div class="blur_back" style="background-image: url('.$bgart.') !important;"></div>
</div>';
			return $output;
		}
	}
}
