<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Sale Product Grid
 * Displays a grid of products that are on sale.
 */


// adds the css to make the widget adjust to its container
add_action('wp_head','product_sale_style');
function product_sale_style( ){
	echo '<style>.col2sale li.product {width:46%!important; margin:0 2% 5% 2% !important;} .col3sale li.product {width:31.3%!important; margin:0 1% 5% 1% !important;}</style>';
	}

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_sale_productgrid', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_sc_sale_productgrid' ) )
{
	class avia_sc_sale_productgrid extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Sale Products', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."sale-product-grid.png";
			$this->config['order']		= 85;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_sale_productgrid';
			$this->config['tooltip'] 	= __('Display a grid of products that are on sale.', 'avia_framework' );
			$this->config['drag-level'] = 3;
		}

		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
				
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
						"type" 	=> "tab",
						"name"  => __("Content" , 'avia_framework'),
						'nodescription' => true
					),
					
				array(
						"name" 	=> __("Display Options", 'avia_framework' ),
						"desc" 	=> __("Select whether you want to show all sale items or just those from a specific category.", 'avia_framework' ),
						"id" 	=> "display",
						"type" 	=> "select",
						"std" 	=> "dropdown",
						"no_first"=>true,
						"subtype" => array( __('Show All Sale Items', 'avia_framework' ) =>'',
											__('Show From A Category', 'avia_framework' ) =>'show-cat')),
					
				array(
						"name" 	=> __("Which Category?", 'avia_framework' ),
						"desc" 	=> __("Choose a product category to display.", 'avia_framework' ),
						"id" 	=> "category",
						"type" 	=> "select",
						"required" => array('display','not',''),
						"taxonomy" => "product_cat",
					    "subtype" => "cat"
				),

				array(
						"name" 	=> __("Columns", 'avia_framework' ),
						"desc" 	=> __("How many columns should be displayed?", 'avia_framework' ),
						"id" 	=> "columns",
						"type" 	=> "select",
						"std" 	=> "3",
						"subtype" => array(	__('2 Columns', 'avia_framework' )=>'2',
											__('3 Columns', 'avia_framework' )=>'3',
											__('4 Columns', 'avia_framework' )=>'4',
											)),
				array(
						"name" 	=> __("Entry Number", 'avia_framework' ),
						"desc" 	=> __("How many items should be displayed?", 'avia_framework' ),
						"id" 	=> "items",
						"type" 	=> "select",
						"std" 	=> "9",
						"subtype" => AviaHtmlHelper::number_array(1,100,1, array('All'=>'-1'))),
				
				array(
						"name" 	=> __("Sorting Options", 'avia_framework' ),
						"desc" 	=> __("Here you can choose how to sort the products.", 'avia_framework' ),
						"id" 	=> "sort",
						"type" 	=> "select",
						"std" 	=> "dropdown",
						"no_first"=>true,
						"subtype" => array( __('Sort alphabetically', 'avia_framework' ) =>'title',
											__('Sort by most recent', 'avia_framework' ) =>'date',
											__('Sort by price', 'avia_framework' ) =>'price',
											__('Sort rating', 'avia_framework' ) =>'rating',
											__('Sort by popularity', 'avia_framework' ) =>'popularity')),
				
				array(
						"name" 	=> __("Ordering Options", 'avia_framework' ),
						"desc" 	=> __("Set the ordering direction based on how the products are sorted.", 'avia_framework' ),
						"id" 	=> "order",
						"type" 	=> "select",
						"std" 	=> "dropdown",
						"no_first"=>true,
						"subtype" => array( __('Ascending Order', 'avia_framework' ) =>'ASC',
											__('Descending Order', 'avia_framework' ) =>'DESC')),

				array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
								
						
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}

		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('columns' => '', 'items' => '', 'sort' => '', 'order' => '', 'category' => '', 'display' => '' ), $atts, $this->config['shortcode']);
				$cat_id = $atts['category'];
			    $items  = $atts['items'];
				$columns  = $atts['columns'];
				$sort  = $atts['sort'];
				$order = $atts['order'];
				$category = get_term_by('id', $cat_id, 'product_cat', 'ARRAY_A');
				if('show-cat' == $atts['display']) {
    			$categoryslug = $category['slug'];
				}
			    
				$content_html = "";
			    if('2' == $atts['columns']) $content_html .= "[products limit='{$items}' columns='{$columns}' orderby='{$sort}' category='".$categoryslug."' cat_operator='AND' order='{$order}' class='col2sale' on_sale='true']";
				if('3' == $atts['columns']) $content_html .= "[products limit='{$items}' columns='{$columns}' orderby='{$sort}' category='".$categoryslug."' cat_operator='AND' order='{$order}' class='col3sale' on_sale='true']";
				if('4' == $atts['columns']) $content_html .= "[products limit='{$items}' columns='{$columns}' orderby='{$sort}' category='".$categoryslug."' cat_operator='AND' order='{$order}' on_sale='true']";
			    // $content_html = "[products limit='{$items}' columns='{$columns}' orderby='{$sort}' on_sale='true']";
			    
			    $output  = "";
				$output .= "<div class='{$av_display_classes}'>".do_shortcode( $content_html )."</div>";
				
				return $output;
			}
	}
}
